/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.init;

import hudson.Extension;
import io.jenkins.plugins.opentelemetry.OtelComponent;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.runtimemetrics.java8.BufferPools;
import io.opentelemetry.instrumentation.runtimemetrics.java8.Classes;
import io.opentelemetry.instrumentation.runtimemetrics.java8.Cpu;
import io.opentelemetry.instrumentation.runtimemetrics.java8.GarbageCollector;
import io.opentelemetry.instrumentation.runtimemetrics.java8.MemoryPools;
import io.opentelemetry.instrumentation.runtimemetrics.java8.Threads;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.YesNoMaybe;

@Extension(dynamicLoadable=YesNoMaybe.MAYBE, optional=true)
public class JvmMonitoringInitializer
implements OtelComponent {
    private static final Logger LOGGER = Logger.getLogger(JvmMonitoringInitializer.class.getName());

    @Override
    public void afterSdkInitialized(OpenTelemetry openTelemetry, ConfigProperties config) {
        boolean defaultEnabled = config.getBoolean("otel.instrumentation.common.default-enabled", true);
        if (!config.getBoolean("otel.instrumentation.runtime-metrics.enabled", defaultEnabled)) {
            return;
        }
        BufferPools.registerObservers((OpenTelemetry)openTelemetry);
        Classes.registerObservers((OpenTelemetry)openTelemetry);
        Cpu.registerObservers((OpenTelemetry)openTelemetry);
        GarbageCollector.registerObservers((OpenTelemetry)openTelemetry);
        MemoryPools.registerObservers((OpenTelemetry)openTelemetry);
        Threads.registerObservers((OpenTelemetry)openTelemetry);
        LOGGER.log(Level.FINE, "Start monitoring Jenkins JVM...");
    }
}

