/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.init;

import hudson.Extension;
import hudson.model.LoadStatistics;
import io.jenkins.plugins.opentelemetry.OtelComponent;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.events.EventEmitter;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import jenkins.YesNoMaybe;
import jenkins.model.Jenkins;

@Extension(dynamicLoadable=YesNoMaybe.MAYBE, optional=true)
public class JenkinsExecutorMonitoringInitializer
implements OtelComponent {
    @Override
    public void afterSdkInitialized(Meter meter, LoggerProvider loggerProvider, EventEmitter eventEmitter, Tracer tracer, ConfigProperties configProperties) {
        ObservableLongMeasurement availableExecutors = meter.gaugeBuilder("jenkins.executor.available").setUnit("1").setDescription("Available executors").ofLongs().buildObserver();
        ObservableLongMeasurement busyExecutors = meter.gaugeBuilder("jenkins.executor.busy").setUnit("1").setDescription("Busy executors").ofLongs().buildObserver();
        ObservableLongMeasurement idleExecutors = meter.gaugeBuilder("jenkins.executor.idle").setUnit("1").setDescription("Idle executors").ofLongs().buildObserver();
        ObservableLongMeasurement onlineExecutors = meter.gaugeBuilder("jenkins.executor.online").setUnit("1").setDescription("Online executors").ofLongs().buildObserver();
        ObservableLongMeasurement connectingExecutors = meter.gaugeBuilder("jenkins.executor.connecting").setUnit("1").setDescription("Connecting executors").ofLongs().buildObserver();
        ObservableLongMeasurement definedExecutors = meter.gaugeBuilder("jenkins.executor.defined").setUnit("1").setDescription("Defined executors").ofLongs().buildObserver();
        ObservableLongMeasurement queueLength = meter.gaugeBuilder("jenkins.executor.queue").setUnit("1").setDescription("Defined executors").ofLongs().buildObserver();
        meter.batchCallback(() -> {
            Jenkins jenkins = Jenkins.get();
            jenkins.getLabels().forEach(label -> {
                LoadStatistics.LoadStatisticsSnapshot loadStatisticsSnapshot = label.loadStatistics.computeSnapshot();
                Attributes attributes = Attributes.of((AttributeKey)AttributeKey.stringKey((String)"label"), (Object)label.getDisplayName());
                availableExecutors.record((long)loadStatisticsSnapshot.getAvailableExecutors(), attributes);
                busyExecutors.record((long)loadStatisticsSnapshot.getBusyExecutors(), attributes);
                idleExecutors.record((long)loadStatisticsSnapshot.getIdleExecutors(), attributes);
                onlineExecutors.record((long)loadStatisticsSnapshot.getOnlineExecutors(), attributes);
                definedExecutors.record((long)loadStatisticsSnapshot.getDefinedExecutors(), attributes);
                connectingExecutors.record((long)loadStatisticsSnapshot.getConnectingExecutors(), attributes);
                queueLength.record((long)loadStatisticsSnapshot.getQueueLength(), attributes);
            });
        }, (ObservableMeasurement)availableExecutors, new ObservableMeasurement[]{busyExecutors, idleExecutors, onlineExecutors, connectingExecutors, definedExecutors, queueLength});
    }
}

