/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.init;

import com.cloudbees.simplediskusage.DiskItem;
import com.cloudbees.simplediskusage.QuickDiskUsagePlugin;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.opentelemetry.OtelComponent;
import io.opentelemetry.api.events.EventEmitter;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.YesNoMaybe;
import jenkins.model.Jenkins;

@Extension(dynamicLoadable=YesNoMaybe.YES, optional=true)
public class DiskUsageMonitoringInitializer
implements OtelComponent {
    private static final Logger LOGGER = Logger.getLogger(DiskUsageMonitoringInitializer.class.getName());
    protected QuickDiskUsagePlugin quickDiskUsagePlugin;

    @Override
    public void afterSdkInitialized(Meter meter, LoggerProvider loggerProvider, EventEmitter eventEmitter, Tracer tracer, ConfigProperties configProperties) {
        meter.gaugeBuilder("jenkins.disk.usage.bytes").ofLongs().setDescription("Disk usage of first level folder in JENKINS_HOME.").setUnit("byte").buildWithCallback(valueObserver -> valueObserver.record(this.calculateDiskUsageInBytes()));
        LOGGER.log(Level.FINE, () -> "Start monitoring Jenkins controller disk usage...");
    }

    private long calculateDiskUsageInBytes() {
        if (this.quickDiskUsagePlugin == null) {
            Jenkins jenkins = Jenkins.get();
            QuickDiskUsagePlugin quickDiskUsagePlugin = (QuickDiskUsagePlugin)jenkins.getPlugin(QuickDiskUsagePlugin.class);
            if (quickDiskUsagePlugin == null) {
                return 0L;
            }
            this.quickDiskUsagePlugin = quickDiskUsagePlugin;
        }
        return this.calculateDiskUsageInBytes(this.quickDiskUsagePlugin);
    }

    private long calculateDiskUsageInBytes(@NonNull QuickDiskUsagePlugin diskUsagePlugin) {
        LOGGER.log(Level.FINE, "calculateDiskUsageInBytes");
        try {
            DiskItem disk = diskUsagePlugin.getDirectoriesUsages().stream().filter(diskItem -> diskItem.getDisplayName().equals("JENKINS_HOME")).findFirst().orElse(null);
            if (disk == null) {
                return 0L;
            }
            return disk.getUsage() * 1024L;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e, () -> "Exception invoking `diskUsagePlugin.getDirectoriesUsages()`");
            return 0L;
        }
    }
}

