/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.computer;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Node;
import hudson.slaves.CloudProvisioningListener;
import hudson.slaves.NodeProvisioner;
import io.jenkins.plugins.opentelemetry.OtelComponent;
import io.opentelemetry.api.events.EventEmitter;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.YesNoMaybe;

@Extension(dynamicLoadable=YesNoMaybe.YES, optional=true)
public class MonitoringCloudListener
extends CloudProvisioningListener
implements OtelComponent {
    private static final Logger LOGGER = Logger.getLogger(MonitoringCloudListener.class.getName());
    private LongCounter failureCloudCounter;
    private LongCounter totalCloudCount;

    @Override
    public void afterSdkInitialized(Meter meter, LoggerProvider loggerProvider, EventEmitter eventEmitter, Tracer tracer, ConfigProperties configProperties) {
        this.failureCloudCounter = meter.counterBuilder("jenkins.cloud.agents.failure").setDescription("Number of failed cloud agents when provisioning").setUnit("1").build();
        this.totalCloudCount = meter.counterBuilder("jenkins.cloud.agents.completed").setDescription("Number of provisioned cloud agents").setUnit("1").build();
        LOGGER.log(Level.FINE, () -> "Start monitoring Jenkins cloud agent provisioning...");
    }

    public void onFailure(NodeProvisioner.PlannedNode plannedNode, Throwable t) {
        this.failureCloudCounter.add(1L);
        LOGGER.log(Level.FINE, () -> "onFailure(" + plannedNode + ")");
    }

    public void onRollback(@NonNull NodeProvisioner.PlannedNode plannedNode, @NonNull Node node, @NonNull Throwable t) {
        this.failureCloudCounter.add(1L);
        LOGGER.log(Level.FINE, () -> "onRollback(" + plannedNode + ")");
    }

    public void onComplete(NodeProvisioner.PlannedNode plannedNode, Node node) {
        this.totalCloudCount.add(1L);
        LOGGER.log(Level.FINE, () -> "onComplete(" + plannedNode + ")");
    }

    @Override
    public void beforeSdkShutdown() {
    }
}

