/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.backend.elastic;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.Hit;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jenkins.plugins.opentelemetry.backend.elastic.ElasticsearchFields;
import io.jenkins.plugins.opentelemetry.job.log.ConsoleNotes;
import io.jenkins.plugins.opentelemetry.job.log.util.LineIterator;
import io.jenkins.plugins.opentelemetry.semconv.JenkinsOtelSemanticAttributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.Scope;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONArray;

public class ElasticsearchBuildLogsLineIterator
implements LineIterator,
Closeable {
    private static final Logger logger = Logger.getLogger(ElasticsearchBuildLogsLineIterator.class.getName());
    public static final Time POINT_IN_TIME_KEEP_ALIVE = Time.of(builder -> builder.time("30s"));
    public static final int PAGE_SIZE = 200;
    public static final int MAX_LINES = 10000;
    final String jobFullName;
    final int runNumber;
    @Nullable
    final String flowNodeId;
    final String traceId;
    final ElasticsearchClient esClient;
    final Tracer tracer;
    long readLines;
    String pointInTimeId;
    @VisibleForTesting
    int queryCounter;
    Iterator<String> delegate;
    boolean endOfStream;

    public ElasticsearchBuildLogsLineIterator(@NonNull String jobFullName, int runNumber, @NonNull String traceId, @NonNull ElasticsearchClient esClient, @NonNull Tracer tracer) {
        this(jobFullName, runNumber, traceId, null, esClient, tracer);
    }

    public ElasticsearchBuildLogsLineIterator(@NonNull String jobFullName, int runNumber, @NonNull String traceId, @Nullable String flowNodeId, @NonNull ElasticsearchClient esClient, @NonNull Tracer tracer) {
        this.tracer = tracer;
        this.jobFullName = jobFullName;
        this.runNumber = runNumber;
        this.traceId = traceId;
        this.flowNodeId = flowNodeId;
        this.esClient = esClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String lazyLoadPointInTimeId() throws IOException {
        if (this.pointInTimeId == null) {
            Span esOpenPitSpan = this.tracer.spanBuilder("ElasticsearchLogsSearchIterator.openPointInTime").setAttribute("query.index", "logs-apm.app-*").setAttribute("query.keepAlive", POINT_IN_TIME_KEEP_ALIVE.time()).startSpan();
            try (Scope esOpenPitSpanScope = esOpenPitSpan.makeCurrent();){
                this.pointInTimeId = this.esClient.openPointInTime(pit -> pit.index("logs-apm.app-*", new String[0]).keepAlive(POINT_IN_TIME_KEEP_ALIVE)).id();
                esOpenPitSpan.setAttribute("pitId", this.pointInTimeId);
            }
            finally {
                esOpenPitSpan.end();
            }
        }
        return this.pointInTimeId;
    }

    @NonNull
    Iterator<String> getCurrentIterator() {
        try {
            if (this.endOfStream) {
                return this.delegate;
            }
            if (this.delegate == null) {
                this.delegate = this.loadNextFormattedLogLines();
            }
            if (this.delegate.hasNext()) {
                return this.delegate;
            }
            this.delegate = this.loadNextFormattedLogLines();
            if (this.readLines > 10000L) {
                this.delegate = Iterators.concat(this.delegate, Collections.singleton("...").iterator());
                this.endOfStream = true;
            } else if (!this.delegate.hasNext()) {
                this.endOfStream = true;
            }
            return this.delegate;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block19: {
            Tracer tracer = logger.isLoggable(Level.FINE) ? this.tracer : TracerProvider.noop().get("noop");
            SpanBuilder spanBuilder = tracer.spanBuilder("ElasticsearchBuildLogsLineIterator.close").setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_ID, (Object)this.jobFullName).setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_RUN_NUMBER, (Object)this.runNumber).setAttribute("pointInTimeId", this.pointInTimeId);
            if (this.flowNodeId != null) {
                spanBuilder.setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_ID, (Object)this.flowNodeId);
            }
            Span closeSpan = spanBuilder.startSpan();
            try (Scope closeSpanScope = closeSpan.makeCurrent();){
                if (this.pointInTimeId == null) break block19;
                Span esClosePitSpan = this.tracer.spanBuilder("Elasticsearch.closePointInTime").setAttribute("query.pointInTimeId", this.pointInTimeId).startSpan();
                try (Scope scope = esClosePitSpan.makeCurrent();){
                    this.esClient.closePointInTime(builder -> builder.id(this.pointInTimeId));
                }
                finally {
                    esClosePitSpan.end();
                    this.pointInTimeId = null;
                }
            }
            finally {
                closeSpan.end();
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.getCurrentIterator().hasNext();
    }

    @Override
    public String next() {
        ++this.readLines;
        return this.getCurrentIterator().next();
    }

    protected Iterator<String> loadNextFormattedLogLines() throws IOException {
        if (this.readLines > Integer.MAX_VALUE) {
            logger.log(Level.INFO, () -> "Skip more than Integer.MAX_VALUE, return empty result");
            return Collections.emptyIterator();
        }
        String loadPointInTimeId = this.lazyLoadPointInTimeId();
        Span esSearchSpan = this.tracer.spanBuilder("ElasticsearchLogsSearchIterator.search").startSpan();
        try {
            Iterator<String> iterator;
            block13: {
                Scope esSearchSpanScope = esSearchSpan.makeCurrent();
                try {
                    esSearchSpan.setAttribute("query.pointInTimeId", this.lazyLoadPointInTimeId()).setAttribute("query.from", this.readLines).setAttribute("query.size", 200L).setAttribute("query.match.traceId", this.traceId).setAttribute("query.match.jobFullName", this.jobFullName).setAttribute("query.match.runNumber", (long)this.runNumber);
                    BoolQuery.Builder queryBuilder = QueryBuilders.bool().must(QueryBuilders.match().field("trace.id").query(FieldValue.of((String)this.traceId)).build()._toQuery(), new Query[]{QueryBuilders.match().field(ElasticsearchFields.FIELD_CI_PIPELINE_ID).query(FieldValue.of((String)this.jobFullName)).build()._toQuery(), QueryBuilders.match().field(ElasticsearchFields.FIELD_CI_PIPELINE_RUN_NUMBER).query(FieldValue.of((long)this.runNumber)).build()._toQuery()});
                    if (this.flowNodeId != null) {
                        esSearchSpan.setAttribute("query.match.flowNodeId", this.flowNodeId);
                        queryBuilder.must(QueryBuilders.match().field(ElasticsearchFields.FIELD_JENKINS_STEP_ID).query(FieldValue.of((String)this.flowNodeId)).build()._toQuery(), new Query[0]);
                    }
                    Query query = queryBuilder.build()._toQuery();
                    SearchRequest searchRequest = new SearchRequest.Builder().pit(pit -> pit.id(loadPointInTimeId).keepAlive(POINT_IN_TIME_KEEP_ALIVE)).from(Integer.valueOf((int)this.readLines)).size(Integer.valueOf(200)).sort(s -> s.field(f -> f.field("@timestamp").order(SortOrder.Asc))).query(query).build();
                    SearchResponse searchResponse = this.esClient.search(searchRequest, ObjectNode.class);
                    List hits = searchResponse.hits().hits();
                    esSearchSpan.setAttribute("response.size", (long)hits.size());
                    iterator = hits.stream().map(new ElasticsearchHitToFormattedLogLine()).filter(Objects::nonNull).iterator();
                    if (esSearchSpanScope == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (esSearchSpanScope != null) {
                            try {
                                esSearchSpanScope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ElasticsearchException e) {
                        esSearchSpan.recordException((Throwable)e);
                        throw e;
                    }
                }
                esSearchSpanScope.close();
            }
            return iterator;
        }
        finally {
            esSearchSpan.end();
            ++this.queryCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void skipLines(long skipLines) {
        Tracer tracer = logger.isLoggable(Level.FINE) ? this.tracer : TracerProvider.noop().get("noop");
        SpanBuilder spanBuilder = tracer.spanBuilder("ElasticsearchBuildLogsLineIterator.skip").setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_ID, (Object)this.jobFullName).setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_RUN_NUMBER, (Object)this.runNumber).setAttribute("pointInTimeId", this.pointInTimeId).setAttribute("skipLines", skipLines);
        Span span = spanBuilder.startSpan();
        try {
            this.readLines = skipLines;
            if (this.delegate == null) {
                span.setAttribute("skippedLines", -1L);
            } else {
                int counter = 0;
                int i = 0;
                while ((long)i < skipLines && this.delegate.hasNext()) {
                    this.delegate.next();
                    ++counter;
                    ++i;
                }
                span.setAttribute("skippedLines", (long)counter);
            }
        }
        finally {
            span.end();
        }
    }

    static class ElasticsearchHitToFormattedLogLine
    implements Function<Hit<ObjectNode>, String> {
        ElasticsearchHitToFormattedLogLine() {
        }

        @Override
        @Nullable
        public String apply(Hit<ObjectNode> hit) {
            JsonNode annotationsAsText;
            ObjectNode source = (ObjectNode)hit.source();
            if (source == null) {
                logger.log(Level.FINE, () -> "Skip log with no source (document id: " + hit.id() + ")");
                return null;
            }
            JsonNode messageAsJsonNode = source.findValue("message");
            if (messageAsJsonNode == null) {
                logger.log(Level.FINE, () -> "Skip log with no message (document id: " + hit.id() + ")");
                return null;
            }
            ObjectNode labels = (ObjectNode)source.findValue("labels");
            String message = messageAsJsonNode.asText();
            JSONArray annotations = labels == null ? null : ((annotationsAsText = labels.get(JenkinsOtelSemanticAttributes.JENKINS_ANSI_ANNOTATIONS.getKey())) == null ? null : JSONArray.fromObject((Object)annotationsAsText.asText()));
            String formattedMessage = ConsoleNotes.readFormattedMessage(message, annotations);
            logger.log(Level.FINEST, () -> "Write: " + formattedMessage + " for document.id: " + hit.id());
            return formattedMessage;
        }
    }
}

