/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.backend.custom;

import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.text.Template;
import io.jenkins.plugins.opentelemetry.TemplateBindingsProvider;
import io.jenkins.plugins.opentelemetry.job.log.LogStorageRetriever;
import io.jenkins.plugins.opentelemetry.job.log.LogsQueryResult;
import io.jenkins.plugins.opentelemetry.job.log.LogsViewHeader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.kohsuke.stapler.framework.io.ByteBuffer;

public class CustomLogStorageRetriever
implements LogStorageRetriever {
    @NonNull
    private final Template buildLogsVisualizationUrlTemplate;
    private final TemplateBindingsProvider templateBindingsProvider;

    public CustomLogStorageRetriever(Template buildLogsVisualizationUrlTemplate, TemplateBindingsProvider templateBindingsProvider) {
        this.buildLogsVisualizationUrlTemplate = buildLogsVisualizationUrlTemplate;
        this.templateBindingsProvider = templateBindingsProvider;
    }

    @Override
    @NonNull
    public LogsQueryResult overallLog(@NonNull String jobFullName, @NonNull int runNumber, @NonNull String traceId, @NonNull String spanId, boolean complete) throws IOException {
        return this.getLogsQueryResult(traceId, spanId);
    }

    @Override
    @NonNull
    public LogsQueryResult stepLog(@NonNull String jobFullName, @NonNull int runNumber, @NonNull String flowNodeId, @NonNull String traceId, @NonNull String spanId, boolean complete) throws IOException {
        return this.getLogsQueryResult(traceId, spanId);
    }

    @NonNull
    private LogsQueryResult getLogsQueryResult(@NonNull String traceId, @NonNull String spanId) throws IOException {
        HashMap<String, String> localBindings = new HashMap<String, String>();
        localBindings.put("traceId", traceId);
        localBindings.put("spanId", spanId);
        Map<String, String> bindings = TemplateBindingsProvider.compose(this.templateBindingsProvider, localBindings).getBindings();
        String logsVisualizationUrl = this.buildLogsVisualizationUrlTemplate.make(bindings).toString();
        String backendName = bindings.get("backendName");
        String backend24x24IconUrl = bindings.get("backend24x24IconUrl");
        return new LogsQueryResult(new ByteBuffer(), new LogsViewHeader(backendName, logsVisualizationUrl, backend24x24IconUrl), StandardCharsets.UTF_8, true);
    }

    public String toString() {
        return "CustomLogStorageRetriever{urlTemplate=" + this.buildLogsVisualizationUrlTemplate + "}";
    }

    @Override
    public void close() throws Exception {
    }
}

