/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.backend;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import io.jenkins.plugins.opentelemetry.backend.ObservabilityBackend;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CustomObservabilityBackend
extends ObservabilityBackend {
    public static final String OTEL_CUSTOM_URL = "OTEL_CUSTOM_URL";
    public static final String DEFAULT_NAME = "Custom Observability Backend";
    private String traceVisualisationUrlTemplate;
    private String metricsVisualizationUrlTemplate;

    @DataBoundConstructor
    public CustomObservabilityBackend() {
    }

    @DataBoundSetter
    public void setTraceVisualisationUrlTemplate(String traceVisualisationUrlTemplate) {
        this.traceVisualisationUrlTemplate = traceVisualisationUrlTemplate;
    }

    @DataBoundSetter
    public void setMetricsVisualizationUrlTemplate(String metricsVisualizationUrlTemplate) {
        this.metricsVisualizationUrlTemplate = metricsVisualizationUrlTemplate;
    }

    @Override
    public Map<String, Object> mergeBindings(Map<String, Object> bindings) {
        return bindings;
    }

    @Override
    @CheckForNull
    public String getTraceVisualisationUrlTemplate() {
        return this.traceVisualisationUrlTemplate;
    }

    @Override
    @CheckForNull
    public String getMetricsVisualizationUrlTemplate() {
        return this.metricsVisualizationUrlTemplate;
    }

    @Override
    @CheckForNull
    public String getIconPath() {
        return "icon-monitor";
    }

    @Override
    @CheckForNull
    public String getEnvVariableName() {
        return OTEL_CUSTOM_URL;
    }

    @Override
    @CheckForNull
    public String getDefaultName() {
        return DEFAULT_NAME;
    }

    public String toString() {
        return "CustomBackend{traceVisualisationUrlTemplate='" + this.traceVisualisationUrlTemplate + "', metricsVisualizationUrl='" + this.metricsVisualizationUrlTemplate + "'}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomObservabilityBackend that = (CustomObservabilityBackend)o;
        return Objects.equals(this.traceVisualisationUrlTemplate, that.traceVisualisationUrlTemplate) && Objects.equals(this.metricsVisualizationUrlTemplate, that.metricsVisualizationUrlTemplate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.traceVisualisationUrlTemplate, this.metricsVisualizationUrlTemplate);
    }

    @Override
    public Map<String, String> getBindings() {
        LinkedHashMap<String, String> bindings = new LinkedHashMap<String, String>();
        bindings.put("backendName", this.getName());
        bindings.put("backend24x24IconUrl", "/plugin/opentelemetry/images/svgs/opentelemetry.svg");
        return bindings;
    }

    @Extension
    @Symbol(value={"customObservabilityBackend"})
    public static class DescriptorImpl
    extends ObservabilityBackend.ObservabilityBackendDescriptor {
        public String getDisplayName() {
            return CustomObservabilityBackend.DEFAULT_NAME;
        }

        @Override
        public int ordinal() {
            return 10;
        }
    }
}

