/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.authentication;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.Extension;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.opentelemetry.authentication.OtlpAuthentication;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

@Extension
public class BearerTokenAuthentication
extends OtlpAuthentication {
    private static final Logger LOGGER = Logger.getLogger(BearerTokenAuthentication.class.getName());
    private String tokenId;

    @DataBoundConstructor
    public BearerTokenAuthentication() {
    }

    public BearerTokenAuthentication(String tokenId) {
        this.tokenId = tokenId;
    }

    private String getAuthenticationHeaderValue() {
        String authenticationTokenValue;
        StringCredentials credentials = (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, (List)Collections.EMPTY_LIST), (CredentialsMatcher)CredentialsMatchers.withId((String)this.tokenId));
        if (credentials == null) {
            LOGGER.log(Level.WARNING, () -> "StringCredentials with id `" + this.tokenId + "` not found. Fall back to empty secret, an authentication error is likely to happen.");
            authenticationTokenValue = "";
        } else {
            authenticationTokenValue = Secret.toString((Secret)credentials.getSecret());
        }
        return authenticationTokenValue;
    }

    @Override
    public void enrichOpenTelemetryAutoConfigureConfigProperties(Map<String, String> configProperties) {
        configProperties.put("otel.exporter.otlp.headers", "Authorization=Bearer " + this.getAuthenticationHeaderValue());
    }

    @Override
    public void enrichOtelEnvironmentVariables(Map<String, String> environmentVariables) {
        environmentVariables.put("OTEL_EXPORTER_OTLP_HEADERS", "authorization=Bearer " + this.getAuthenticationHeaderValue());
    }

    public String getTokenId() {
        return this.tokenId;
    }

    @DataBoundSetter
    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public String toString() {
        return "BearerTokenAuthentication{tokenId='" + this.tokenId + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BearerTokenAuthentication that = (BearerTokenAuthentication)o;
        return Objects.equals(this.tokenId, that.tokenId);
    }

    public int hashCode() {
        return Objects.hash(this.tokenId);
    }

    public ListBoxModel doFillTokenIdItems() {
        if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            return new StandardListBoxModel().includeCurrentValue(this.tokenId);
        }
        return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.get(), StringCredentials.class, Collections.emptyList(), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StringCredentials.class)})).includeCurrentValue(this.tokenId);
    }

    @Extension
    @Symbol(value={"bearerTokenAuthentication"})
    public static class DescriptorImpl
    extends OtlpAuthentication.AbstractDescriptor {
        public String getDisplayName() {
            return "Bearer Token Authentication";
        }

        public ListBoxModel doFillTokenIdItems() {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return new StandardListBoxModel();
            }
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.get(), StringCredentials.class, Collections.emptyList(), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StringCredentials.class)}));
        }
    }
}

