/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Plugin;
import hudson.model.FreeStyleBuild;
import hudson.model.Item;
import hudson.model.Run;
import hudson.util.VersionNumber;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.mixin.ChangeRequestSCMHead;
import jenkins.scm.api.mixin.TagSCMHead;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;

public class OtelUtils {
    public static final String FREESTYLE = "freestyle";
    public static final String MATRIX = "matrix";
    public static final String MAVEN = "maven";
    public static final String MULTIBRANCH = "multibranch";
    public static final String WORKFLOW = "workflow";
    public static final String UNKNOWN = "unknown";
    public static final String BRANCH = "branch";
    public static final String CHANGE_REQUEST = "change_request";
    public static final String TAG = "tag";
    public static final String JENKINS_CORE = "jenkins-core";
    public static final String UNKNOWN_VALUE = "#unknown";
    private static final List<String> noteworthyConfigurationPropertyNames = Arrays.asList("otel.resource.attributes", "otel.service.name", "otel.traces.exporter", "otel.metrics.exporter", "otel.logs.exporter", "otel.exporter.otlp.endpoint", "otel.exporter.otlp.traces.endpoint", "otel.exporter.otlp.metrics.endpoint", "otel.exporter.jaeger.endpoint", "otel.exporter.prometheus.port", "otel.instrumentation.jenkins.web.enabled");
    private static final List<AttributeKey> noteworthyResourceAttributeKeys = Arrays.asList(ResourceAttributes.SERVICE_NAME, ResourceAttributes.SERVICE_NAMESPACE, ResourceAttributes.SERVICE_VERSION);

    @CheckForNull
    public static String getSystemPropertyOrEnvironmentVariable(String environmentVariableName) {
        String systemPropertyName = environmentVariableName.replace('_', '.').toLowerCase(Locale.ROOT);
        String systemProperty = System.getProperty(systemPropertyName);
        if (StringUtils.isNotBlank((String)systemProperty)) {
            return systemProperty;
        }
        String environmentVariable = System.getenv(environmentVariableName);
        if (StringUtils.isNotBlank((String)environmentVariable)) {
            return environmentVariable;
        }
        return null;
    }

    @NonNull
    public static Function<Span, String> spanToDebugString() {
        return span -> {
            if (span == null) {
                return "#null#";
            }
            if (span instanceof ReadableSpan) {
                ReadableSpan readableSpan = (ReadableSpan)span;
                SpanData spanData = readableSpan.toSpanData();
                return "span(name: " + readableSpan.getName() + ", spanId: " + spanData.getSpanId() + ", parentSpanId: " + spanData.getParentSpanId() + ", traceId: " + spanData.getTraceId() + ", )";
            }
            return span.toString();
        };
    }

    @NonNull
    public static String getProjectType(Run run) {
        if (OtelUtils.isFreestyle(run)) {
            return FREESTYLE;
        }
        if (OtelUtils.isMaven(run)) {
            return MAVEN;
        }
        if (OtelUtils.isMatrix(run)) {
            return MATRIX;
        }
        if (OtelUtils.isMultibranch(run)) {
            return MULTIBRANCH;
        }
        if (OtelUtils.isWorkflow(run)) {
            return WORKFLOW;
        }
        return UNKNOWN;
    }

    @NonNull
    public static String getMultibranchType(Run run) {
        if (OtelUtils.isMultibranch(run)) {
            if (OtelUtils.isMultibranchChangeRequest(run)) {
                return CHANGE_REQUEST;
            }
            if (OtelUtils.isMultibranchBranch(run)) {
                return BRANCH;
            }
            if (OtelUtils.isMultibranchTag(run)) {
                return TAG;
            }
        }
        return UNKNOWN;
    }

    public static boolean isMultibranchTag(Run run) {
        if (OtelUtils.isMultibranch(run)) {
            return SCMHead.HeadByItem.findHead((Item)run.getParent()) instanceof TagSCMHead;
        }
        return false;
    }

    public static boolean isMultibranchChangeRequest(Run run) {
        if (OtelUtils.isMultibranch(run)) {
            return SCMHead.HeadByItem.findHead((Item)run.getParent()) instanceof ChangeRequestSCMHead;
        }
        return false;
    }

    public static boolean isMultibranchBranch(Run run) {
        if (OtelUtils.isMultibranch(run)) {
            return !OtelUtils.isMultibranchChangeRequest(run) && !OtelUtils.isMultibranchTag(run);
        }
        return false;
    }

    public static boolean isMultibranch(Run run) {
        if (run == null) {
            return false;
        }
        return run instanceof WorkflowRun && run.getParent().getParent() instanceof WorkflowMultiBranchProject;
    }

    public static boolean isWorkflow(Run run) {
        if (run == null) {
            return false;
        }
        return run instanceof WorkflowRun && !(run.getParent().getParent() instanceof WorkflowMultiBranchProject);
    }

    public static boolean isFreestyle(Run run) {
        if (run == null) {
            return false;
        }
        return run instanceof FreeStyleBuild;
    }

    @NonNull
    public static boolean isMatrix(Run run) {
        if (run == null) {
            return false;
        }
        return OtelUtils.isInstance(run, "hudson.matrix.MatrixBuild") || OtelUtils.isInstance(run, "hudson.matrix.MatrixProject") || OtelUtils.isInstance(run, "hudson.matrix.MatrixRun");
    }

    public static boolean isMaven(Run run) {
        if (run == null) {
            return false;
        }
        return OtelUtils.isInstance(run, "hudson.maven.AbstractMavenBuild") || OtelUtils.isInstance(run, "hudson.maven.MavenModuleSetBuild") || OtelUtils.isInstance(run, "hudson.maven.MavenBuild");
    }

    private static boolean isInstance(Object o, String clazz) {
        return o != null && o.getClass().getName().equals(clazz);
    }

    @NonNull
    public static String toDebugString(@Nullable Span span) {
        return OtelUtils.spanToDebugString().apply(span);
    }

    @NonNull
    public static String urlEncode(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    @NonNull
    public static String getJenkinsVersion() {
        VersionNumber versionNumber = Jenkins.getVersion();
        return versionNumber == null ? UNKNOWN_VALUE : versionNumber.toString();
    }

    @NonNull
    public static String getOpentelemetryPluginVersion() {
        Jenkins instance = Jenkins.getInstanceOrNull();
        if (instance == null) {
            return UNKNOWN_VALUE;
        }
        Plugin opentelemetryPlugin = instance.getPlugin("opentelemetry");
        return opentelemetryPlugin == null ? UNKNOWN_VALUE : opentelemetryPlugin.getWrapper().getVersion();
    }

    public static String prettyPrintOtelSdkConfig(ConfigProperties configProperties, Resource resource) {
        return "SDK [config: " + OtelUtils.prettyPrintConfiguration(configProperties) + ", resource: " + OtelUtils.prettyPrintResource(resource) + "]";
    }

    public static String prettyPrintConfiguration(ConfigProperties config) {
        LinkedHashMap<String, String> message = new LinkedHashMap<String, String>();
        for (String attributeName : noteworthyConfigurationPropertyNames) {
            String attributeValue = config.getString(attributeName);
            if (attributeValue == null) continue;
            message.put(attributeName, attributeValue);
        }
        return message.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(", "));
    }

    public static Map<String, String> noteworthyConfigProperties(ConfigProperties configProperties) {
        TreeMap<String, String> noteworthyConfigProperties = new TreeMap<String, String>();
        noteworthyConfigurationPropertyNames.forEach(k -> {
            if (configProperties.getString(k) != null) {
                noteworthyConfigProperties.put((String)k, configProperties.getString(k));
            }
        });
        return noteworthyConfigProperties;
    }

    public static String prettyPrintResource(@Nullable Resource resource) {
        if (resource == null) {
            return "#null#";
        }
        LinkedHashMap<String, String> message = new LinkedHashMap<String, String>();
        for (AttributeKey attributeKey : noteworthyResourceAttributeKeys) {
            Object attributeValue = resource.getAttribute(attributeKey);
            if (attributeValue == null) continue;
            message.put(attributeKey.getKey(), Objects.toString(attributeValue, "#null#"));
        }
        return message.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(", "));
    }
}

