/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.ExtensionList;
import io.jenkins.plugins.opentelemetry.OpenTelemetryConfiguration;
import io.jenkins.plugins.opentelemetry.OtelComponent;
import io.jenkins.plugins.opentelemetry.OtelUtils;
import io.jenkins.plugins.opentelemetry.opentelemetry.ClosingOpenTelemetry;
import io.jenkins.plugins.opentelemetry.opentelemetry.autoconfigure.ConfigPropertiesUtils;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.events.EventEmitter;
import io.opentelemetry.api.events.EventEmitterProvider;
import io.opentelemetry.api.events.GlobalEventEmitterProvider;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.instrumentation.resources.ProcessResourceProvider;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.PreDestroy;

@Extension
public class OpenTelemetrySdkProvider {
    private static final Logger LOGGER = Logger.getLogger(OpenTelemetrySdkProvider.class.getName());
    public static final String DEFAULT_OTEL_JAVA_DISABLED_RESOURCE_PROVIDERS = ProcessResourceProvider.class.getName();
    protected transient ClosingOpenTelemetry openTelemetry;
    protected transient Resource resource;
    protected transient ConfigProperties config;
    @Nullable
    protected transient OpenTelemetrySdk openTelemetrySdk;
    @NonNull
    private final transient TracerDelegate tracer = new TracerDelegate();
    protected transient Meter meter;
    protected transient LoggerProvider loggerProvider;
    protected transient EventEmitter eventEmitter;

    @NonNull
    public Tracer getTracer() {
        return (Tracer)Preconditions.checkNotNull((Object)this.tracer.getDelegate());
    }

    @NonNull
    public Meter getMeter() {
        return (Meter)Preconditions.checkNotNull((Object)this.meter);
    }

    @NonNull
    public Resource getResource() {
        return (Resource)Preconditions.checkNotNull((Object)this.resource);
    }

    @NonNull
    public ConfigProperties getConfig() {
        return (ConfigProperties)Preconditions.checkNotNull((Object)this.config);
    }

    public boolean isOtelLogsEnabled() {
        String otelLogsExporter = this.config.getString("otel.logs.exporter");
        return otelLogsExporter != null && !otelLogsExporter.equals("none");
    }

    public boolean isOtelLogsMirrorToDisk() {
        String otelLogsExporter = this.config.getString("otel.logs.mirror_to_disk");
        return otelLogsExporter != null && otelLogsExporter.equals("true");
    }

    @NonNull
    public LoggerProvider getLoggerProvider() {
        return (LoggerProvider)Preconditions.checkNotNull((Object)this.loggerProvider);
    }

    @NonNull
    public EventEmitter getEventEmitter() {
        return (EventEmitter)Preconditions.checkNotNull((Object)this.eventEmitter);
    }

    @VisibleForTesting
    @NonNull
    protected OpenTelemetrySdk getOpenTelemetrySdk() {
        return (OpenTelemetrySdk)Preconditions.checkNotNull((Object)this.openTelemetrySdk);
    }

    @PreDestroy
    public void shutdown() {
        if (this.openTelemetrySdk != null) {
            LOGGER.log(Level.FINE, "Shutdown...");
            LOGGER.log(Level.FINE, () -> "Shutdown Otel SDK on components: " + ExtensionList.lookup(OtelComponent.class).stream().sorted().map(e -> e.getClass().getName()).collect(Collectors.joining(", ")));
            ExtensionList.lookup(OtelComponent.class).stream().sorted().forEachOrdered(OtelComponent::beforeSdkShutdown);
            this.openTelemetry.close();
            CompletableResultCode shutdown = this.openTelemetrySdk.shutdown();
            if (!shutdown.join(1L, TimeUnit.SECONDS).isSuccess()) {
                LOGGER.log(Level.WARNING, "Failure to shutdown OTel SDK");
            }
        }
        GlobalOpenTelemetry.resetForTest();
        GlobalEventEmitterProvider.resetForTest();
    }

    public void initialize(@NonNull OpenTelemetryConfiguration configuration) {
        this.shutdown();
        if (configuration.getEndpoint().isPresent()) {
            this.initializeOtlp(configuration);
        } else {
            this.initializeNoOp();
        }
        LOGGER.log(Level.FINE, () -> "Initialize Otel SDK on components: " + ExtensionList.lookup(OtelComponent.class).stream().sorted().map(e -> e.getClass().getName()).collect(Collectors.joining(", ")));
        ExtensionList.lookup(OtelComponent.class).stream().sorted().forEachOrdered(otelComponent -> {
            otelComponent.afterSdkInitialized(this.meter, this.loggerProvider, this.eventEmitter, this.tracer, this.config);
            otelComponent.afterSdkInitialized(this.openTelemetry, this.config);
        });
    }

    public void initializeOtlp(@NonNull OpenTelemetryConfiguration configuration) {
        AutoConfiguredOpenTelemetrySdkBuilder sdkBuilder = AutoConfiguredOpenTelemetrySdk.builder();
        sdkBuilder.addPropertiesSupplier(configuration::toOpenTelemetryProperties);
        sdkBuilder.addPropertiesCustomizer((java.util.function.Function)((Function)configProperties -> {
            this.config = configProperties;
            return Collections.emptyMap();
        }));
        sdkBuilder.addResourceCustomizer((resource, configProperties) -> {
            this.resource = Resource.builder().putAll(resource).putAll(configuration.toOpenTelemetryResource()).build();
            return this.resource;
        });
        sdkBuilder.disableShutdownHook().setResultAsGlobal();
        this.openTelemetrySdk = sdkBuilder.build().getOpenTelemetrySdk();
        this.openTelemetry = new ClosingOpenTelemetry((OpenTelemetry)this.openTelemetrySdk);
        String opentelemetryPluginVersion = OtelUtils.getOpentelemetryPluginVersion();
        this.tracer.setDelegate(this.openTelemetry.getTracerProvider().tracerBuilder("io.jenkins.opentelemetry").setInstrumentationVersion(opentelemetryPluginVersion).build());
        this.meter = this.openTelemetry.getMeterProvider().meterBuilder("io.jenkins.opentelemetry").setInstrumentationVersion(opentelemetryPluginVersion).build();
        this.loggerProvider = this.openTelemetrySdk.getSdkLoggerProvider();
        this.eventEmitter = GlobalEventEmitterProvider.get().eventEmitterBuilder("io.jenkins.opentelemetry").setInstrumentationVersion(opentelemetryPluginVersion).setEventDomain("jenkins").build();
        LOGGER.log(Level.INFO, () -> "OpenTelemetry SDK initialized: " + OtelUtils.prettyPrintOtelSdkConfig(this.config, this.resource));
    }

    @VisibleForTesting
    public void initializeNoOp() {
        LOGGER.log(Level.FINE, "initializeNoOp");
        this.openTelemetrySdk = null;
        this.resource = Resource.getDefault();
        this.config = ConfigPropertiesUtils.emptyConfig();
        this.openTelemetry = ClosingOpenTelemetry.noop();
        GlobalOpenTelemetry.resetForTest();
        GlobalEventEmitterProvider.resetForTest();
        GlobalOpenTelemetry.set((OpenTelemetry)OpenTelemetry.noop());
        this.tracer.setDelegate(OpenTelemetry.noop().getTracer("io.jenkins.opentelemetry"));
        this.meter = OpenTelemetry.noop().getMeter("io.jenkins.opentelemetry");
        this.loggerProvider = OpenTelemetry.noop().getLogsBridge();
        this.eventEmitter = EventEmitterProvider.noop().get("io.jenkins.opentelemetry");
        LOGGER.log(Level.FINE, "OpenTelemetry initialized as NoOp");
    }

    public static OpenTelemetrySdkProvider get() {
        return (OpenTelemetrySdkProvider)ExtensionList.lookupSingleton(OpenTelemetrySdkProvider.class);
    }

    static class TracerDelegate
    implements Tracer {
        private Tracer delegate;

        TracerDelegate() {
        }

        public synchronized SpanBuilder spanBuilder(@Nonnull String spanName) {
            return this.delegate.spanBuilder(spanName);
        }

        public synchronized void setDelegate(Tracer delegate) {
            this.delegate = delegate;
        }

        public synchronized Tracer getDelegate() {
            return this.delegate;
        }
    }
}

