/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.neuvector;

import hudson.AbortException;
import hudson.util.Secret;
import io.jenkins.plugins.neuvector.Config;
import io.jenkins.plugins.neuvector.Log;
import io.jenkins.plugins.neuvector.TrustAllStrategy;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class NeuVectorWorker {
    private static final int HTTP_CLIENT_CONFIG_TIMEOUT_SECOND = 60;
    private Log logger;
    private Config config;
    private String token;

    public NeuVectorWorker(Log logger, Config config) {
        this.logger = logger;
        this.config = config;
    }

    public void scan() throws IOException {
        try (CloseableHttpClient httpclient = this.makeHttpClient();){
            this.getToken(httpclient);
            try {
                this.requestScan(httpclient);
            }
            finally {
                this.logout(httpclient);
            }
        }
    }

    public void testConnection() throws IOException {
        try (CloseableHttpClient httpclient = this.makeHttpClient();){
            this.getToken(httpclient);
            this.logout(httpclient);
        }
    }

    private CloseableHttpClient makeHttpClient() throws AbortException {
        SSLConnectionSocketFactory sslsf;
        SSLContextBuilder builder = new SSLContextBuilder();
        try {
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            sslsf = new SSLConnectionSocketFactory(builder.build(), (HostnameVerifier)new TrustAllStrategy());
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new AbortException("SSL context builder error.");
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).build();
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setDefaultRequestConfig(config).build();
    }

    private void getToken(CloseableHttpClient httpclient) throws AbortException {
        block25: {
            String uriPathForGetToken = "/v1/auth";
            URI uriForGetToken = this.buildUri(this.config.getControllerIP(), this.config.getControllerPort(), uriPathForGetToken);
            HttpPost httpPostForGetToken = new HttpPost(uriForGetToken);
            httpPostForGetToken.addHeader("Content-Type", "application/json");
            JSONObject passwordJson = new JSONObject();
            passwordJson.put("username", (Object)this.config.getUser());
            passwordJson.put("password", (Object)this.config.getPassword());
            JSONObject httpBodyJson = new JSONObject();
            httpBodyJson.put("password", (Object)passwordJson);
            try {
                httpPostForGetToken.setEntity((HttpEntity)new StringEntity(httpBodyJson.toString()));
            }
            catch (UnsupportedEncodingException e) {
                if (this.logger != null) {
                    this.logger.log("Unsupported encoding from NeuVector Username and/or Password in global configuration.");
                }
                throw new AbortException("Unsupported encoding from NeuVector Username and/or Password in global configuration.");
            }
            try (CloseableHttpResponse httpResponseFromGetToken = httpclient.execute((HttpUriRequest)httpPostForGetToken);){
                int statusCode = httpResponseFromGetToken.getStatusLine().getStatusCode();
                HttpEntity httpEntityFromGetToken = httpResponseFromGetToken.getEntity();
                String serverMessageFromGetToken = EntityUtils.toString((HttpEntity)httpEntityFromGetToken);
                EntityUtils.consume((HttpEntity)httpEntityFromGetToken);
                if (statusCode == 200) {
                    this.token = JSONObject.fromObject((Object)serverMessageFromGetToken).getJSONObject("token").getString("token");
                    break block25;
                }
                if (statusCode == 401 || statusCode == 404 || statusCode == 405) {
                    if (this.logger != null) {
                        this.logger.log("Invalid credential of NeuVector controller");
                    }
                    throw new AbortException("Invalid credential of NeuVector controller");
                }
                if (this.logger != null) {
                    this.logger.log("Failed to get token. Http status code: " + statusCode + ". Message: " + serverMessageFromGetToken);
                }
                throw new AbortException("Failed to get token. Http status code: " + statusCode + ". Message: " + serverMessageFromGetToken);
            }
            catch (ClientProtocolException e) {
                if (this.logger != null) {
                    this.logger.log("Invalid NeuVector controller IP or port.");
                }
                throw new AbortException("Invalid NeuVector controller IP or port.");
            }
            catch (AbortException e) {
                throw new AbortException();
            }
            catch (IOException e) {
                if (this.logger != null) {
                    this.logger.log("NeuVector controller connection error.");
                }
                throw new AbortException("NeuVector controller connection error.");
            }
        }
    }

    private void requestScan(CloseableHttpClient httpclient) throws IOException {
        block16: {
            long startTimeMillis = System.currentTimeMillis();
            int timeoutSeconds = this.config.getTimeout() * 60;
            String uriPathForScan = "/v1/scan/repository";
            URI uriForScan = this.buildUri(this.config.getControllerIP(), this.config.getControllerPort(), uriPathForScan);
            HttpPost httpPostForScan = new HttpPost(uriForScan);
            httpPostForScan.addHeader("Content-Type", "application/json");
            httpPostForScan.addHeader("X-Auth-Token", this.token);
            JSONObject httpBodyJson = new JSONObject();
            JSONObject requestJson = new JSONObject();
            requestJson.put("repository", (Object)this.config.getRepository());
            if (this.config.getTag() != null) {
                requestJson.put("tag", (Object)this.config.getTag());
            }
            if (this.config.isLocal()) {
                requestJson.put("registry", (Object)"");
                requestJson.put("username", (Object)"");
                requestJson.put("password", (Object)"");
            } else {
                requestJson.put("registry", (Object)this.config.getRegistry().getRegUrl());
                requestJson.put("username", (Object)this.config.getRegistry().getRegUsername());
                requestJson.put("password", (Object)Secret.toString((Secret)this.config.getRegistry().getRegPassword()).trim());
            }
            requestJson.put("scan_layers", (Object)this.config.getScanLayers());
            httpBodyJson.put("request", (Object)requestJson);
            try {
                httpPostForScan.setEntity((HttpEntity)new StringEntity(httpBodyJson.toString()));
            }
            catch (UnsupportedEncodingException e) {
                this.logger.log("Unsupported encoding from registry, repository or tag.");
                throw new AbortException();
            }
            try (CloseableHttpResponse httpResponseFromScan = null;){
                httpResponseFromScan = httpclient.execute((HttpUriRequest)httpPostForScan);
                while (httpResponseFromScan.getStatusLine().getStatusCode() == 304) {
                    long elapsedSeconds;
                    if (timeoutSeconds > 0 && (elapsedSeconds = (System.currentTimeMillis() - startTimeMillis) / 1000L) > (long)timeoutSeconds) {
                        this.logger.log("Time out.");
                        throw new AbortException();
                    }
                    httpResponseFromScan = httpclient.execute((HttpUriRequest)httpPostForScan);
                    this.logger.log("Scanning in progress...");
                }
                int statusCode = httpResponseFromScan.getStatusLine().getStatusCode();
                HttpEntity httpEntityFromScan = httpResponseFromScan.getEntity();
                String serverMessageFromScan = "N/A";
                if (httpEntityFromScan != null) {
                    serverMessageFromScan = EntityUtils.toString((HttpEntity)httpEntityFromScan);
                    EntityUtils.consume((HttpEntity)httpEntityFromScan);
                }
                if (statusCode == 200 && httpEntityFromScan != null) {
                    this.processScanReport(serverMessageFromScan);
                    break block16;
                }
                this.logger.log("Scan failed. Http status code: " + statusCode + ". Message: " + serverMessageFromScan);
                throw new AbortException("Scan failed.");
            }
        }
    }

    private void logout(CloseableHttpClient httpclient) throws IOException {
        String uriPathForLogout = "/v1/auth";
        URI uriForLogout = this.buildUri(this.config.getControllerIP(), this.config.getControllerPort(), uriPathForLogout);
        HttpDelete httpDeleteForLogout = new HttpDelete(uriForLogout);
        httpDeleteForLogout.addHeader("Content-Type", "application/json");
        httpDeleteForLogout.addHeader("X-Auth-Token", this.token);
        CloseableHttpResponse httpResponseFromLogout = httpclient.execute((HttpUriRequest)httpDeleteForLogout);
        httpResponseFromLogout.close();
    }

    private URI buildUri(String host, int port, String path) throws AbortException {
        URI uri;
        try {
            uri = new URIBuilder().setScheme("https").setHost(host).setPort(port).setPath(path).build();
        }
        catch (URISyntaxException e) {
            this.logger.log("URI syntax error from NeuVector Controller IP and/or API port in global configuration.");
            throw new AbortException();
        }
        return uri;
    }

    private void processScanReport(String serverMessageFromScan) throws AbortException {
        int currentHighSeverity = 0;
        int currentMediumSeverity = 0;
        boolean foundName = false;
        HashSet<String> namesToPresent = new HashSet<String>();
        HashSet<String> nameSetOfVulnerability = new HashSet<String>();
        if (this.config.getNameOfVulnerabilityToFailOne() != null && !this.config.getNameOfVulnerabilityToFailOne().isEmpty()) {
            nameSetOfVulnerability.add(this.config.getNameOfVulnerabilityToFailOne().toLowerCase());
        }
        if (this.config.getNameOfVulnerabilityToFailTwo() != null && !this.config.getNameOfVulnerabilityToFailTwo().isEmpty()) {
            nameSetOfVulnerability.add(this.config.getNameOfVulnerabilityToFailTwo().toLowerCase());
        }
        if (this.config.getNameOfVulnerabilityToFailThree() != null && !this.config.getNameOfVulnerabilityToFailThree().isEmpty()) {
            nameSetOfVulnerability.add(this.config.getNameOfVulnerabilityToFailThree().toLowerCase());
        }
        if (this.config.getNameOfVulnerabilityToFailFour() != null && !this.config.getNameOfVulnerabilityToFailFour().isEmpty()) {
            nameSetOfVulnerability.add(this.config.getNameOfVulnerabilityToFailFour().toLowerCase());
        }
        this.logger.log();
        this.logger.log("************************ Scan Report ************************");
        JSONObject reportJson = JSONObject.fromObject((Object)serverMessageFromScan).getJSONObject("report");
        if (!this.config.isLocal()) {
            this.logger.log("Registry URL: " + reportJson.getString("registry"));
        }
        this.logger.log("Repository: " + reportJson.getString("repository"));
        this.logger.log("Tag: " + reportJson.getString("tag"));
        this.logger.log();
        this.logger.log("********************** Vulnerabilities **********************");
        this.logger.log();
        JSONArray vulnerabilityArray = reportJson.getJSONArray("vulnerabilities");
        if (vulnerabilityArray.size() == 0) {
            this.logger.log("Scanned. No vulnerabilities found.");
        } else {
            for (int i = 0; i < vulnerabilityArray.size(); ++i) {
                JSONObject vulnerabilityObject = vulnerabilityArray.getJSONObject(i);
                int vulnerabilityNumber = i + 1;
                String name = vulnerabilityObject.getString("name").toLowerCase();
                String severity = vulnerabilityObject.getString("severity");
                this.logger.log("********************** Vulnerability " + vulnerabilityNumber + " **********************");
                this.logger.log("Name: " + name.toUpperCase());
                this.logger.log("Score: " + vulnerabilityObject.get("score"));
                this.logger.log("Severity: " + severity);
                this.logger.log("Vectors: " + vulnerabilityObject.getString("vectors"));
                this.logger.log("Description: " + vulnerabilityObject.getString("description"));
                this.logger.log("Package_name: " + vulnerabilityObject.getString("package_name"));
                this.logger.log("Package_version: " + vulnerabilityObject.getString("package_version"));
                this.logger.log("Fixed_version: " + vulnerabilityObject.getString("fixed_version"));
                this.logger.log("Link: " + vulnerabilityObject.getString("link"));
                this.logger.log();
                if (!nameSetOfVulnerability.isEmpty() && nameSetOfVulnerability.contains(name)) {
                    foundName = true;
                    namesToPresent.add(name.toUpperCase());
                }
                if (severity.equalsIgnoreCase("High")) {
                    ++currentHighSeverity;
                    continue;
                }
                if (!severity.equalsIgnoreCase("Medium")) continue;
                ++currentMediumSeverity;
            }
        }
        if (this.config.getScanLayers()) {
            this.logger.log();
            if (reportJson.has("layers")) {
                this.logger.log("**************** Layer Vulnerability History ****************");
                this.logger.log();
                JSONArray layerArray = reportJson.getJSONArray("layers");
                for (int i = 0; i < layerArray.size(); ++i) {
                    JSONObject layerObject = layerArray.getJSONObject(i);
                    String layerDigest = layerObject.getString("digest").substring(0, 12);
                    JSONArray layerVulnerabilityArray = layerObject.getJSONArray("vulnerabilities");
                    this.logger.log("Layer digest " + layerDigest + " contains " + layerVulnerabilityArray.size() + " vulnerabilities.");
                    this.logger.log();
                    for (int j = 0; j < layerVulnerabilityArray.size(); ++j) {
                        JSONObject layerVulnerabilityObject = layerVulnerabilityArray.getJSONObject(j);
                        this.logger.log("Name: " + layerVulnerabilityObject.getString("name") + ", Score: " + layerVulnerabilityObject.get("score") + ", Package_name: " + layerVulnerabilityObject.getString("package_name") + ", Package_version: " + layerVulnerabilityObject.getString("package_version") + ", Fixed_version: " + layerVulnerabilityObject.getString("fixed_version") + ", Link: " + layerVulnerabilityObject.getString("link"));
                    }
                    this.logger.log();
                }
            } else {
                this.logger.log("*** Your Controller Does Not Support Layer Vulnerability Scan ***");
            }
        }
        this.makeIfFailDecision(currentHighSeverity, currentMediumSeverity, foundName, namesToPresent);
    }

    private void makeIfFailDecision(int currentHighSeverity, int currentMediumSeverity, boolean foundName, Set<String> namesToPresent) throws AbortException {
        int configNumberOfMedium;
        int configNumberOfHigh;
        boolean numberExceed = false;
        StringBuilder statementBuilder = new StringBuilder();
        if (this.config.getNumberOfHighSeverityToFail() != null && !this.config.getNumberOfHighSeverityToFail().isEmpty() && (configNumberOfHigh = Integer.parseInt(this.config.getNumberOfHighSeverityToFail())) != 0 && configNumberOfHigh <= currentHighSeverity) {
            numberExceed = true;
            statementBuilder.append(currentHighSeverity).append(" High severity vulnerabilities");
        }
        if (this.config.getNumberOfMediumSeverityToFail() != null && !this.config.getNumberOfMediumSeverityToFail().isEmpty() && (configNumberOfMedium = Integer.parseInt(this.config.getNumberOfMediumSeverityToFail())) != 0 && configNumberOfMedium <= currentMediumSeverity) {
            if (numberExceed) {
                statementBuilder.append(", ");
            }
            numberExceed = true;
            statementBuilder.append(currentMediumSeverity).append(" Medium severity vulnerabilities");
        }
        if (foundName) {
            if (numberExceed) {
                statementBuilder.append(", and ");
            }
            statementBuilder.append("vulnerabilities: ").append(namesToPresent.toString());
        }
        if (numberExceed || foundName) {
            statementBuilder.append(" are present.");
            this.logger.log("Build failed because " + statementBuilder.toString());
            throw new AbortException();
        }
    }
}

