/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.neuvector;

import com.google.common.base.Strings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.ArtifactArchiver;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.neuvector.Config;
import io.jenkins.plugins.neuvector.Log;
import io.jenkins.plugins.neuvector.Messages;
import io.jenkins.plugins.neuvector.NeuVectorAction;
import io.jenkins.plugins.neuvector.NeuVectorWorker;
import io.jenkins.plugins.neuvector.Registry;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class NeuVectorBuilder
extends Builder
implements SimpleBuildStep {
    private static final String REGISTRY_DROPDOWN_DEFAULT = "Please select a registry:";
    private final String repository;
    private String tag;
    private String numberOfHighSeverityToFail;
    private String numberOfMediumSeverityToFail;
    private String nameOfVulnerabilityToFailOne;
    private String nameOfVulnerabilityToFailTwo;
    private String nameOfVulnerabilityToFailThree;
    private String nameOfVulnerabilityToFailFour;
    private final String registrySelection;
    private static int buildStep;
    private static int buildHash;

    public static synchronized void setBuildStep(int buildStep) {
        NeuVectorBuilder.buildStep = buildStep;
    }

    public static synchronized void setBuildHash(int buildHash) {
        NeuVectorBuilder.buildHash = buildHash;
    }

    @DataBoundConstructor
    public NeuVectorBuilder(String repository, String registrySelection) {
        this.repository = repository;
        this.registrySelection = registrySelection;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getTag() {
        return this.tag;
    }

    public String getNumberOfHighSeverityToFail() {
        return this.numberOfHighSeverityToFail;
    }

    public String getNumberOfMediumSeverityToFail() {
        return this.numberOfMediumSeverityToFail;
    }

    public String getNameOfVulnerabilityToFailOne() {
        return this.nameOfVulnerabilityToFailOne;
    }

    public String getNameOfVulnerabilityToFailTwo() {
        return this.nameOfVulnerabilityToFailTwo;
    }

    public String getNameOfVulnerabilityToFailThree() {
        return this.nameOfVulnerabilityToFailThree;
    }

    public String getNameOfVulnerabilityToFailFour() {
        return this.nameOfVulnerabilityToFailFour;
    }

    public String getRegistrySelection() {
        return this.registrySelection;
    }

    @DataBoundSetter
    public void setTag(String tag) {
        this.tag = tag.trim();
    }

    @DataBoundSetter
    public void setNumberOfHighSeverityToFail(String numberOfHighSeverityToFail) {
        this.numberOfHighSeverityToFail = numberOfHighSeverityToFail.trim();
    }

    @DataBoundSetter
    public void setNumberOfMediumSeverityToFail(String numberOfMediumSeverityToFail) {
        this.numberOfMediumSeverityToFail = numberOfMediumSeverityToFail.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToFailOne(String nameOfVulnerabilityToFailOne) {
        this.nameOfVulnerabilityToFailOne = nameOfVulnerabilityToFailOne.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToFailTwo(String nameOfVulnerabilityToFailTwo) {
        this.nameOfVulnerabilityToFailTwo = nameOfVulnerabilityToFailTwo.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToFailThree(String nameOfVulnerabilityToFailThree) {
        this.nameOfVulnerabilityToFailThree = nameOfVulnerabilityToFailThree.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToFailFour(String nameOfVulnerabilityToFailFour) {
        this.nameOfVulnerabilityToFailFour = nameOfVulnerabilityToFailFour.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        String artifactName = "NeuVectorReport_" + run.getParent().getDisplayName() + "_" + run.getNumber();
        String reportNumber = null;
        if (run.hashCode() != buildHash) {
            NeuVectorBuilder.setBuildHash(run.hashCode());
            NeuVectorBuilder.setBuildStep(1);
        } else {
            NeuVectorBuilder.setBuildStep(buildStep + 1);
        }
        reportNumber = Integer.toString(buildStep);
        artifactName = artifactName + "-" + reportNumber;
        FilePath workspaceFP = new FilePath(workspace, artifactName);
        try (PrintStream printStream = new PrintStream(workspaceFP.write(), false, "UTF-8");){
            Log logger = new Log(printStream, listener);
            Config config = this.printInfoFromUser(run, listener, logger);
            NeuVectorWorker worker = new NeuVectorWorker(logger, config);
            worker.scan();
        }
        finally {
            this.archiveAndAddAction(run, workspace, launcher, listener, artifactName, reportNumber);
            workspaceFP.delete();
        }
    }

    private Config printInfoFromUser(Run<?, ?> run, TaskListener listener, Log logger) throws AbortException {
        EnvVars env;
        DescriptorImpl globalConfig = this.getDescriptor();
        String controllerIP = globalConfig.getControllerIP().trim();
        int controllerPort = Integer.parseInt(globalConfig.getControllerPort().trim());
        String user = globalConfig.getUser().trim();
        String password = globalConfig.getPassword().trim();
        int timeout = globalConfig.getTimeout();
        List<Registry> registries = globalConfig.getRegistries();
        if (controllerIP.isEmpty() || user.isEmpty() || password.isEmpty()) {
            throw new AbortException("Missing global configuration for NeuVector.");
        }
        if (this.repository == null || this.registrySelection == null) {
            throw new AbortException("repository and registrySelection both are required.");
        }
        try {
            env = run.getEnvironment(listener);
        }
        catch (IOException | InterruptedException e) {
            throw new AbortException("Error when getting Jenkins project environment.");
        }
        String currentRepository = env.expand(this.repository.trim());
        String currentTag = env.expand(this.tag);
        logger.log();
        logger.log("*************************************************************");
        boolean isLocal = true;
        Registry selectRegistry = null;
        if (Strings.isNullOrEmpty((String)this.registrySelection) || this.registrySelection.equalsIgnoreCase(REGISTRY_DROPDOWN_DEFAULT)) {
            throw new AbortException("Please select a registry or choose Local.");
        }
        if (this.registrySelection.equalsIgnoreCase("Local")) {
            logger.log("Local case.");
        } else {
            if (registries == null) {
                throw new AbortException("Registry " + this.registrySelection + " in current project is missing or deleted in global configuration.");
            }
            boolean found = false;
            for (Registry registry : registries) {
                if (registry.getNickname().isEmpty() || registry.getRegUrl().isEmpty()) {
                    throw new AbortException("Registry nickname and URL cannot be empty");
                }
                if (!registry.getNickname().equalsIgnoreCase(this.registrySelection)) continue;
                found = true;
                isLocal = false;
                selectRegistry = registry;
                logger.log("Registry: " + this.registrySelection);
                logger.log("Registry URL: " + selectRegistry.getRegUrl());
                logger.log("Registry Username: " + selectRegistry.getRegUsername());
                break;
            }
            if (!found) {
                throw new AbortException("Registry " + this.registrySelection + " in current project is missing or deleted in global configuration.");
            }
        }
        logger.log("Repository: " + currentRepository);
        logger.log("Tag: " + currentTag);
        return new Config(controllerIP, controllerPort, user, password, timeout, isLocal, selectRegistry, currentRepository, currentTag, this.numberOfHighSeverityToFail, this.numberOfMediumSeverityToFail, this.nameOfVulnerabilityToFailOne, this.nameOfVulnerabilityToFailTwo, this.nameOfVulnerabilityToFailThree, this.nameOfVulnerabilityToFailFour);
    }

    private void archiveAndAddAction(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener, String artifactName, String reportNumber) throws InterruptedException {
        ArtifactArchiver artifactArchiver = new ArtifactArchiver(artifactName);
        artifactArchiver.perform(run, workspace, launcher, listener);
        run.addAction((Action)new NeuVectorAction(run, artifactName, reportNumber));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    static {
        buildHash = 0;
    }

    @Symbol(value={"neuvector"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String controllerIP;
        private String controllerPort;
        private String user;
        private String password;
        private int timeout;
        private List<Registry> registries;

        public void setControllerIP(String controllerIP) {
            this.controllerIP = controllerIP;
        }

        public void setControllerPort(String controllerPort) {
            this.controllerPort = controllerPort;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public void setRegistries(List<Registry> registries) {
            this.registries = registries;
        }

        public String getControllerIP() {
            return this.controllerIP;
        }

        public String getControllerPort() {
            return this.controllerPort;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public List<Registry> getRegistries() {
            return this.registries;
        }

        public DescriptorImpl() {
            this.load();
        }

        public ListBoxModel doFillRegistrySelectionItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(NeuVectorBuilder.REGISTRY_DROPDOWN_DEFAULT);
            items.add("Local");
            if (this.registries != null) {
                for (Registry reg : this.registries) {
                    items.add(reg.getNickname());
                }
            }
            return items;
        }

        public FormValidation doCheckRegistrySelection(@QueryParameter String value) {
            if (Strings.isNullOrEmpty((String)value) || value.equalsIgnoreCase(NeuVectorBuilder.REGISTRY_DROPDOWN_DEFAULT)) {
                return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_registrySelection());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckControllerIP(@QueryParameter String value) {
            if (Strings.isNullOrEmpty((String)value) || value.trim().isEmpty() || value.trim().matches("^(http|https)://.*$")) {
                return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_controllerIP());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckControllerPort(@QueryParameter String value) {
            try {
                if (Integer.parseInt(value.trim()) < 0) {
                    return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_controllerPort());
                }
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_controllerPort());
            }
        }

        public FormValidation doCheckUser(@QueryParameter String value) {
            if (Strings.isNullOrEmpty((String)value) || value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_user());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPassword(@QueryParameter String value) {
            if (Strings.isNullOrEmpty((String)value) || value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_password());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTimeout(@QueryParameter String value) {
            try {
                if (Integer.parseInt(value) < 0) {
                    return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_timeout());
                }
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_timeout());
            }
        }

        public FormValidation doTestConnection(@QueryParameter(value="controllerIP") String controllerIP, @QueryParameter(value="controllerPort") String controllerPort, @QueryParameter(value="user") String user, @QueryParameter(value="password") String password) {
            int port;
            try {
                port = Integer.parseInt(controllerPort.trim());
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_controllerPort());
            }
            Config config = new Config(controllerIP, port, user, password, 0, false, null, null, null, null, null, null, null, null, null);
            NeuVectorWorker worker = new NeuVectorWorker(null, config);
            try {
                worker.testConnection();
                return FormValidation.ok((String)"Connection Success");
            }
            catch (IOException e) {
                return FormValidation.error((String)("Connection error: " + e.getMessage()));
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.NeuVectorBuilder_DescriptorImpl_DisplayName();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            block3: {
                try {
                    JSONObject registriesJsonObj = formData.getJSONObject("registries");
                    if (registriesJsonObj == null || registriesJsonObj.isEmpty()) {
                        this.registries = null;
                    }
                }
                catch (JSONException e) {
                    JSONArray registriesJsonArray = formData.getJSONArray("registries");
                    if (registriesJsonArray != null && !registriesJsonArray.isEmpty()) break block3;
                    this.registries = null;
                }
            }
            req.bindJSON((Object)this, formData);
            this.save();
            return true;
        }
    }
}

