/*
 * Decompiled with CFR 0.152.
 */
package de.westemeyer.plugins.multiselect.parser;

import de.westemeyer.plugins.multiselect.MultiselectConfigurationFormat;
import de.westemeyer.plugins.multiselect.MultiselectDecisionTree;
import de.westemeyer.plugins.multiselect.MultiselectVariableDescriptor;
import de.westemeyer.plugins.multiselect.parser.ConfigParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.tools.ant.filters.StringInputStream;

public class MultiselectParameterParser {
    private final MultiselectConfigurationFormat format;
    private String validationResult;

    public MultiselectParameterParser(MultiselectConfigurationFormat format) {
        this.format = format;
    }

    public String getValidationResult() {
        return this.validationResult;
    }

    public MultiselectDecisionTree parseConfiguration(String input) throws IOException {
        try (StringInputStream inputStream = new StringInputStream(input);){
            MultiselectDecisionTree multiselectDecisionTree = this.parseConfiguration(inputStream);
            return multiselectDecisionTree;
        }
    }

    private MultiselectDecisionTree parseConfiguration(StringInputStream inputStream) {
        ConfigParser parser = this.format.createParser();
        MultiselectDecisionTree multiselectDecisionTree = parser.analyzeConfiguration((InputStream)inputStream);
        this.validationResult = parser.getValidationResult();
        List<MultiselectVariableDescriptor> variableDescriptions = multiselectDecisionTree.getVariableDescriptions();
        for (int i = 0; i < variableDescriptions.size(); ++i) {
            MultiselectVariableDescriptor columnDescriptor = variableDescriptions.get(i);
            columnDescriptor.setInitialValues(multiselectDecisionTree.getInitialValuesForColumn(i));
        }
        return multiselectDecisionTree;
    }
}

