/*
 * Decompiled with CFR 0.152.
 */
package de.westemeyer.plugins.multiselect;

import de.westemeyer.plugins.multiselect.Messages;
import de.westemeyer.plugins.multiselect.MultiselectConfigurationFormat;
import de.westemeyer.plugins.multiselect.MultiselectDecisionTree;
import de.westemeyer.plugins.multiselect.MultiselectParameterValue;
import de.westemeyer.plugins.multiselect.UUIDGenerator;
import de.westemeyer.plugins.multiselect.parser.MultiselectParameterParser;
import hudson.Extension;
import hudson.Util;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.verb.POST;

public class MultiselectParameterDefinition
extends ParameterDefinition {
    private static final long serialVersionUID = 3307975793661301522L;
    private static final Logger LOGGER = Logger.getLogger(MultiselectParameterDefinition.class.getName());
    private static final String PARAMETER_NAME = "name";
    private MultiselectDecisionTree decisionTree;
    private MultiselectConfigurationFormat format;
    private final String uuid = UUIDGenerator.generateUUID(15);

    @DataBoundConstructor
    public MultiselectParameterDefinition(String name, String description, MultiselectDecisionTree decisionTree, MultiselectConfigurationFormat format) {
        super(name, description);
        this.decisionTree = decisionTree;
        this.format = format;
    }

    @JavaScriptMethod
    public String[] getItemList(Integer[] coordinates) {
        Queue<Integer> itemPath = MultiselectParameterDefinition.createCoordinates(coordinates);
        ArrayList returnList = new ArrayList();
        try {
            this.decisionTree.visitSelectedItems(itemPath, (item, column) -> {
                if (itemPath.isEmpty()) {
                    item.getChildren().forEach(child -> returnList.add(child.getDisplayLabel()));
                }
                return true;
            });
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
        return returnList.toArray(new String[0]);
    }

    public static Queue<Integer> createCoordinates(Integer ... coordinates) {
        ArrayDeque<Integer> itemPath = new ArrayDeque<Integer>();
        Collections.addAll(itemPath, coordinates);
        return itemPath;
    }

    @Nullable
    public ParameterValue getDefaultParameterValue() {
        return new MultiselectParameterValue(this.getName(), new HashMap<String, String>());
    }

    public ParameterValue createValue(StaplerRequest staplerRequest, JSONObject jsonObject) {
        return this.createValue((Map<String, Object>)jsonObject);
    }

    public MultiselectParameterValue createValue(Map<String, Object> jsonObject) {
        HashMap<String, Integer> selectedValues = new HashMap<String, Integer>();
        jsonObject.forEach((key, value) -> {
            if (!key.equals(PARAMETER_NAME) && value instanceof String && ((String)value).length() > 0) {
                try {
                    selectedValues.put((String)key, Integer.valueOf((String)value));
                }
                catch (NumberFormatException exception) {
                    LOGGER.log(Level.WARNING, "Invalid configuration index value sent from form", exception);
                }
            }
        });
        try {
            return new MultiselectParameterValue(this.getName(), this.decisionTree.resolveValues(selectedValues));
        }
        catch (Exception e) {
            return new MultiselectParameterValue(this.getName(), new HashMap<String, String>());
        }
    }

    public ParameterValue createValue(StaplerRequest staplerRequest) {
        return this.getDefaultParameterValue();
    }

    public MultiselectDecisionTree getDecisionTree() {
        return this.decisionTree;
    }

    public void setDecisionTree(MultiselectDecisionTree decisionTree) {
        this.decisionTree = decisionTree;
    }

    public MultiselectConfigurationFormat getFormat() {
        return this.format;
    }

    public void setFormat(MultiselectConfigurationFormat format) {
        this.format = format;
    }

    public String getUuid() {
        return this.uuid;
    }

    @Extension
    @Symbol(value={"multiselect"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        @POST
        public FormValidation doCheckConfiguration(@QueryParameter String value) throws IOException {
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)Messages.FormValidation_ConfigurationIsEmpty());
            }
            MultiselectParameterParser parser = new MultiselectParameterParser(MultiselectConfigurationFormat.CSV);
            parser.parseConfiguration(value);
            String validation = parser.getValidationResult();
            if (validation != null) {
                return FormValidation.warning((String)validation);
            }
            return FormValidation.ok();
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.MultiselectParameterDefinition_DisplayName();
        }

        public ParameterDefinition newInstance(@Nullable StaplerRequest req, @Nonnull JSONObject formData) {
            return this.newInstance(formData.getString("configuration"), formData.getString(MultiselectParameterDefinition.PARAMETER_NAME), formData.getString("description"));
        }

        public MultiselectParameterDefinition newInstance(String configuration, String name, String description) {
            MultiselectDecisionTree multiselectDecisionTree;
            MultiselectConfigurationFormat format = MultiselectConfigurationFormat.CSV;
            try {
                multiselectDecisionTree = new MultiselectParameterParser(format).parseConfiguration(configuration);
            }
            catch (IOException exception) {
                LOGGER.log(Level.WARNING, "Error trying to parse configuration format.");
                multiselectDecisionTree = new MultiselectDecisionTree();
            }
            return new MultiselectParameterDefinition(name, description, multiselectDecisionTree, format);
        }
    }
}

