/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.orka;

import hudson.Extension;
import hudson.model.Label;
import hudson.model.LoadStatistics;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import io.jenkins.plugins.orka.OrkaCloud;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension(ordinal=200.0)
public class NoDelayProvisionerStrategy
extends NodeProvisioner.Strategy {
    private static final Logger logger = Logger.getLogger(NoDelayProvisionerStrategy.class.getName());

    public NodeProvisioner.StrategyDecision apply(NodeProvisioner.StrategyState strategyState) {
        Label label = strategyState.getLabel();
        LoadStatistics.LoadStatisticsSnapshot snapshot = strategyState.getSnapshot();
        int availableCapacity = snapshot.getAvailableExecutors() + snapshot.getConnectingExecutors() + strategyState.getPlannedCapacitySnapshot() + strategyState.getAdditionalPlannedCapacity();
        int currentDemand = snapshot.getQueueLength();
        logger.log(Level.FINE, "Available capacity={0}, currentDemand={1}", new Object[]{availableCapacity, currentDemand});
        if (availableCapacity < currentDemand) {
            Jenkins jenkinsInstance = Jenkins.get();
            for (Cloud cloud : jenkinsInstance.clouds) {
                OrkaCloud orka;
                if (!(cloud instanceof OrkaCloud) || !cloud.canProvision(label) || !(orka = (OrkaCloud)cloud).getNoDelayProvisioning()) continue;
                Collection plannedNodes = cloud.provision(label, currentDemand - availableCapacity);
                logger.log(Level.FINE, "Planned {0} new nodes", plannedNodes.size());
                strategyState.recordPendingLaunches(plannedNodes);
                logger.log(Level.FINE, "After provisioning, available capacity={0}, currentDemand={1}", new Object[]{availableCapacity += plannedNodes.size(), currentDemand});
                break;
            }
        }
        if (availableCapacity >= currentDemand) {
            logger.log(Level.FINE, "Provisioning completed");
            return NodeProvisioner.StrategyDecision.PROVISIONING_COMPLETED;
        }
        logger.log(Level.FINE, "Provisioning not complete, consulting remaining strategies");
        return NodeProvisioner.StrategyDecision.CONSULT_REMAINING_STRATEGIES;
    }
}

