/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabserverconfig.servers.helpers;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainSpecification;
import com.cloudbees.plugins.credentials.domains.HostnameSpecification;
import com.cloudbees.plugins.credentials.domains.SchemeSpecification;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.gitlabserverconfig.credentials.PersonalAccessToken;
import io.jenkins.plugins.gitlabserverconfig.credentials.PersonalAccessTokenImpl;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.utils.AccessTokenUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class GitLabPersonalAccessTokenCreator
extends Descriptor<GitLabPersonalAccessTokenCreator>
implements Describable<GitLabPersonalAccessTokenCreator> {
    public static final Logger LOGGER = Logger.getLogger(GitLabPersonalAccessTokenCreator.class.getName());
    private static final List<AccessTokenUtils.Scope> GL_PLUGIN_REQUIRED_SCOPE = ImmutableList.of((Object)AccessTokenUtils.Scope.API, (Object)AccessTokenUtils.Scope.READ_REGISTRY, (Object)AccessTokenUtils.Scope.READ_USER, (Object)AccessTokenUtils.Scope.READ_REPOSITORY);

    public GitLabPersonalAccessTokenCreator() {
        super(GitLabPersonalAccessTokenCreator.class);
    }

    private String getShortName(String tokenName) {
        int SHORT_NAME_LENGTH = 8;
        return tokenName.substring(0, SHORT_NAME_LENGTH);
    }

    public Descriptor<GitLabPersonalAccessTokenCreator> getDescriptor() {
        return this;
    }

    @NonNull
    public String getDisplayName() {
        return "Convert login and password to token";
    }

    public ListBoxModel doFillCredentialsIdItems(@QueryParameter String serverUrl, @QueryParameter String credentialsId) {
        Jenkins jenkins = Jenkins.get();
        if (!jenkins.hasPermission(Jenkins.ADMINISTER)) {
            return new StandardListBoxModel().includeCurrentValue(credentialsId);
        }
        return new StandardUsernameListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)jenkins, StandardUsernamePasswordCredentials.class, URIRequirementBuilder.fromUri((String)StringUtils.defaultIfBlank((String)serverUrl, (String)"https://gitlab.com")).build(), CredentialsMatchers.always()).includeMatchingAs(Jenkins.getAuthentication(), (ItemGroup)jenkins, StandardUsernamePasswordCredentials.class, URIRequirementBuilder.fromUri((String)StringUtils.defaultIfBlank((String)serverUrl, (String)"https://gitlab.com")).build(), CredentialsMatchers.always());
    }

    @RequirePOST
    public FormValidation doCreateTokenByCredentials(@QueryParameter String serverUrl, @QueryParameter String credentialsId) {
        Jenkins jenkins = Jenkins.get();
        jenkins.checkPermission(Jenkins.ADMINISTER);
        if (StringUtils.isEmpty((String)credentialsId)) {
            return FormValidation.error((String)"Please specify credentials to create token");
        }
        StandardUsernamePasswordCredentials credentials = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)jenkins, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)StringUtils.defaultIfBlank((String)serverUrl, (String)"https://gitlab.com")).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        if (credentials == null) {
            credentials = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)jenkins, (Authentication)Jenkins.getAuthentication(), (List)URIRequirementBuilder.fromUri((String)StringUtils.defaultIfBlank((String)serverUrl, (String)"https://gitlab.com")).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        }
        if (Objects.isNull(credentials)) {
            return FormValidation.error((String)"Can't create GitLab token, credentials are null");
        }
        try {
            String tokenName = UUID.randomUUID().toString();
            String token = AccessTokenUtils.createPersonalAccessToken((String)StringUtils.defaultIfBlank((String)serverUrl, (String)"https://gitlab.com"), (String)credentials.getUsername(), (String)Secret.toString((Secret)credentials.getPassword()), (String)tokenName, GL_PLUGIN_REQUIRED_SCOPE);
            tokenName = this.getShortName(tokenName);
            this.createCredentials(serverUrl, token, credentials.getUsername(), tokenName);
            return FormValidation.ok((String)"Created credentials with id %s ", (Object[])new Object[]{tokenName});
        }
        catch (GitLabApiException e) {
            return FormValidation.error((Throwable)e, (String)"Can't create GL token - %s", (Object[])new Object[]{e.getMessage()});
        }
    }

    @RequirePOST
    public FormValidation doCreateTokenByPassword(@QueryParameter String serverUrl, @QueryParameter String login, @QueryParameter String password) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        try {
            String tokenName = UUID.randomUUID().toString();
            String token = AccessTokenUtils.createPersonalAccessToken((String)StringUtils.defaultIfBlank((String)serverUrl, (String)"https://gitlab.com"), (String)login, (String)password, (String)tokenName, GL_PLUGIN_REQUIRED_SCOPE);
            tokenName = this.getShortName(tokenName);
            this.createCredentials(serverUrl, token, login, tokenName);
            return FormValidation.ok((String)"Created credentials with id %s", (Object[])new Object[]{tokenName});
        }
        catch (GitLabApiException e) {
            return FormValidation.error((Throwable)e, (String)"Can't create GL token for %s - %s", (Object[])new Object[]{login, e.getMessage()});
        }
    }

    private void createCredentials(@Nullable String serverUrl, String token, String username, String tokenName) {
        String url = StringUtils.defaultIfBlank((String)serverUrl, (String)"https://gitlab.com");
        String description = String.format("Auto Generated by %s server for %s user", url, username);
        PersonalAccessTokenImpl credentials = new PersonalAccessTokenImpl(CredentialsScope.GLOBAL, tokenName, description, token);
        this.saveCredentials(url, credentials);
    }

    private void saveCredentials(String serverUrl, PersonalAccessToken credentials) {
        URI serverUri = URI.create(StringUtils.defaultIfBlank((String)serverUrl, (String)"https://gitlab.com"));
        List<DomainSpecification> specifications = Arrays.asList(new SchemeSpecification(serverUri.getScheme()), new HostnameSpecification(serverUri.getHost(), null));
        Domain domain = new Domain(serverUri.getHost(), "GitLab domain (autogenerated)", specifications);
        try (ACLContext acl = ACL.as((Authentication)ACL.SYSTEM);){
            new SystemCredentialsProvider.StoreImpl().addDomain(domain, new Credentials[]{credentials});
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Can't add credentials for domain", e);
        }
    }
}

