/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource.helpers;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.model.listeners.SCMListener;
import hudson.model.queue.QueueListener;
import hudson.model.queue.Tasks;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.AccessControlled;
import hudson.util.LogTaskListener;
import io.jenkins.plugins.gitlabbranchsource.BranchSCMRevision;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSource;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSourceContext;
import io.jenkins.plugins.gitlabbranchsource.MergeRequestSCMHead;
import io.jenkins.plugins.gitlabbranchsource.MergeRequestSCMRevision;
import io.jenkins.plugins.gitlabbranchsource.helpers.GitLabHelper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.plugins.git.GitTagSCMRevision;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMRevisionAction;
import jenkins.scm.api.SCMSource;
import org.acegisecurity.Authentication;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.models.CommitStatus;
import org.gitlab4j.api.models.MergeRequest;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;

public class GitLabPipelineStatusNotifier {
    public static final Logger LOGGER = Logger.getLogger(GitLabPipelineStatusNotifier.class.getName());
    static final String GITLAB_PIPELINE_STATUS_PREFIX = "jenkinsci";
    static final String GITLAB_PIPELINE_STATUS_DELIMITER = "/";
    static final Pattern MERGE_REQUEST_JOB_NAME_FORMAT = Pattern.compile("MR-(\\d+)(|-(merge|head))");

    private static String getRootUrl(Run<?, ?> build) {
        try {
            return DisplayURLProvider.get().getRunURL(build);
        }
        catch (IllegalStateException e) {
            return "";
        }
    }

    private static GitLabSCMSourceContext getSourceContext(Run<?, ?> build, GitLabSCMSource source) {
        return (GitLabSCMSourceContext)new GitLabSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(source.getTraits());
    }

    private static GitLabSCMSource getSource(Run<?, ?> build) {
        SCMSource s = SCMSource.SourceByItem.findSource((Item)build.getParent());
        if (s instanceof GitLabSCMSource) {
            return (GitLabSCMSource)s;
        }
        return null;
    }

    private static String getStatusName(GitLabSCMSourceContext sourceContext, Run<?, ?> build, @NonNull EnvVars envVars, SCMRevision revision) {
        return GitLabPipelineStatusNotifier.getStatusName(sourceContext, build.getFullDisplayName(), revision, envVars);
    }

    private static String getStatusName(GitLabSCMSourceContext sourceContext, Job<?, ?> job, @NonNull EnvVars envVars, SCMRevision revision) {
        return GitLabPipelineStatusNotifier.getStatusName(sourceContext, job.getFullDisplayName(), revision, envVars);
    }

    static String getStatusName(GitLabSCMSourceContext sourceContext, String fullDisplayName, SCMRevision revision, @NonNull EnvVars envVars) {
        String type;
        if (revision instanceof BranchSCMRevision) {
            type = "branch";
        } else if (revision instanceof MergeRequestSCMRevision) {
            type = GitLabPipelineStatusNotifier.getMrBuildName((MergeRequestSCMRevision)revision);
        } else if (revision instanceof GitTagSCMRevision) {
            type = "tag";
        } else {
            type = "UNKNOWN";
            LOGGER.log(Level.WARNING, () -> "Unknown SCMRevision implementation " + revision.getClass().getName() + ", append" + type + " to status name");
        }
        Object pipelinePrefix = sourceContext.getBuildStatusNameCustomPart().trim();
        if (!((String)pipelinePrefix).isEmpty()) {
            pipelinePrefix = envVars.expand((String)pipelinePrefix);
            if (!sourceContext.getBuildStatusNameOverwrite()) {
                pipelinePrefix = "jenkinsci/" + (String)pipelinePrefix;
            }
        } else {
            pipelinePrefix = GITLAB_PIPELINE_STATUS_PREFIX;
        }
        if (!sourceContext.getIgnoreTypeInStatusName()) {
            pipelinePrefix = (String)pipelinePrefix + GITLAB_PIPELINE_STATUS_DELIMITER + type;
        }
        String statusName = pipelinePrefix;
        LOGGER.log(Level.FINEST, () -> "Retrieved status name is: " + statusName);
        return statusName;
    }

    static String getRevisionRef(SCMRevision revision) {
        String refName = revision instanceof MergeRequestSCMRevision ? ((MergeRequestSCMRevision)revision).getOrigin().getHead().getName() : revision.getHead().getName();
        LOGGER.log(Level.FINEST, () -> "Retrieved revision ref is: " + refName);
        return refName;
    }

    private static String getMrBuildName(MergeRequestSCMRevision revision) {
        return revision.isMerge() ? "mr-merge" : "mr-head";
    }

    private static void logComment(Run<?, ?> build, TaskListener listener) {
        GitLabSCMSource source = GitLabPipelineStatusNotifier.getSource(build);
        if (source == null) {
            return;
        }
        GitLabSCMSourceContext sourceContext = GitLabPipelineStatusNotifier.getSourceContext(build, source);
        if (!sourceContext.logCommentEnabled()) {
            return;
        }
        String url = GitLabPipelineStatusNotifier.getRootUrl(build);
        if (url.isEmpty()) {
            listener.getLogger().println("Can not determine Jenkins root URL. Comments are disabled until a root URL is configured in Jenkins global configuration.");
            return;
        }
        Result result = build.getResult();
        LOGGER.log(Level.FINE, String.format("Log Comment Result: %s", result));
        String note = "";
        String symbol = "";
        if (Result.SUCCESS.equals(result)) {
            if (!sourceContext.doLogSuccess()) {
                return;
            }
            symbol = ":heavy_check_mark: ";
            note = "The Jenkins CI build passed ";
        } else if (Result.UNSTABLE.equals(result)) {
            symbol = ":heavy_multiplication_x: ";
            note = "The Jenkins CI build failed ";
        } else if (Result.FAILURE.equals(result)) {
            symbol = ":heavy_multiplication_x: ";
            note = "The Jenkins CI build failed ";
        } else if (result != null) {
            symbol = ":no_entry_sign: ";
            note = "The Jenkins CI build aborted ";
        }
        String suffix = " - [Details](" + url + ")";
        SCMRevision revision = SCMRevisionAction.getRevision((SCMSource)source, build);
        try {
            GitLabApi gitLabApi = GitLabHelper.apiBuilder((AccessControlled)build.getParent(), source.getServerName());
            String sudoUsername = sourceContext.getSudoUser();
            if (!sudoUsername.isEmpty()) {
                gitLabApi.sudo(sudoUsername);
            }
            try {
                EnvVars envVars = build.getEnvironment(listener);
                String buildName = "**" + GitLabPipelineStatusNotifier.getStatusName(sourceContext, build, envVars, revision) + ":** ";
                if (revision instanceof BranchSCMRevision) {
                    String hash = ((BranchSCMRevision)revision).getHash();
                    gitLabApi.getCommitsApi().addComment((Object)source.getProjectPath(), hash, symbol + buildName + note + suffix);
                } else if (revision instanceof MergeRequestSCMRevision) {
                    MergeRequestSCMHead head = (MergeRequestSCMHead)revision.getHead();
                    gitLabApi.getNotesApi().createMergeRequestNote((Object)source.getProjectPath(), Long.valueOf(head.getId()), symbol + buildName + note + suffix);
                } else if (revision instanceof GitTagSCMRevision) {
                    String hash = ((GitTagSCMRevision)revision).getHash();
                    gitLabApi.getCommitsApi().addComment((Object)source.getProjectPath(), hash, symbol + buildName + note + suffix);
                }
            }
            catch (IOException | InterruptedException e) {
                LOGGER.log(Level.INFO, "Could not send status notification for " + build.getFullDisplayName() + " to " + source.getServerName(), e);
            }
        }
        catch (GitLabApiException e) {
            LOGGER.log(Level.WARNING, "Exception caught:" + e, e);
        }
    }

    static Long getSourceProjectId(Job job, GitLabApi gitLabApi, String projectPath) {
        MergeRequest mr;
        LOGGER.log(Level.INFO, "Getting source project ID from MR");
        Matcher m = MERGE_REQUEST_JOB_NAME_FORMAT.matcher(job.getName());
        if (!m.matches()) {
            LOGGER.log(Level.WARNING, String.format("Job name does not match expected format: [%s], [%s]", job.getName(), MERGE_REQUEST_JOB_NAME_FORMAT.pattern()));
            return null;
        }
        Long mrId = Long.parseLong(m.group(1));
        try {
            mr = gitLabApi.getMergeRequestApi().getMergeRequest((Object)projectPath, mrId);
        }
        catch (GitLabApiException e) {
            if (!e.getMessage().contains("Cannot transition status")) {
                LOGGER.log(Level.WARNING, String.format("Exception caught: %s", e.getMessage()));
            }
            return null;
        }
        Long sourceProjectId = mr.getSourceProjectId();
        LOGGER.log(Level.INFO, "Got source project ID from MR: {0}", String.valueOf(sourceProjectId));
        return sourceProjectId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendNotifications(Run<?, ?> build, TaskListener listener, Boolean useResult) {
        String hash;
        Constants.CommitBuildState state;
        GitLabSCMSource source = GitLabPipelineStatusNotifier.getSource(build);
        if (source == null) {
            return;
        }
        GitLabSCMSourceContext sourceContext = GitLabPipelineStatusNotifier.getSourceContext(build, source);
        if (sourceContext.notificationsDisabled()) {
            return;
        }
        String url = GitLabPipelineStatusNotifier.getRootUrl(build);
        if (url.isEmpty()) {
            listener.getLogger().println("Can not determine Jenkins root URL. Commit status notifications are disabled until a root URL is configured in Jenkins global configuration.");
            return;
        }
        Result result = null;
        if (useResult.booleanValue()) {
            result = build.getResult();
            LOGGER.log(Level.FINE, String.format("Result: %s", result));
        }
        CommitStatus status = new CommitStatus();
        status.setTargetUrl(url);
        if (Result.SUCCESS.equals(result)) {
            status.setDescription(build.toString() + ": This commit looks good.");
            status.setStatus("SUCCESS");
            state = Constants.CommitBuildState.SUCCESS;
        } else if (Result.UNSTABLE.equals(result)) {
            status.setDescription(build.toString() + ": This commit is unstable with partial failure.");
            if (sourceContext.getMarkUnstableAsSuccess()) {
                status.setStatus("SUCCESS");
                state = Constants.CommitBuildState.SUCCESS;
            } else {
                status.setStatus("FAILED");
                state = Constants.CommitBuildState.FAILED;
            }
        } else if (Result.FAILURE.equals(result)) {
            status.setDescription(build.toString() + ": There was a failure building this commit.");
            status.setStatus("FAILED");
            state = Constants.CommitBuildState.FAILED;
        } else if (result != null) {
            status.setDescription(build.toString() + ": Something is wrong with the build of this commit.");
            status.setStatus("CANCELED");
            state = Constants.CommitBuildState.CANCELED;
        } else {
            status.setDescription(build.toString() + ": Build started...");
            status.setStatus("RUNNING");
            state = Constants.CommitBuildState.RUNNING;
        }
        SCMRevision revision = SCMRevisionAction.getRevision((SCMSource)source, build);
        if (revision instanceof BranchSCMRevision) {
            listener.getLogger().format("[GitLab Pipeline Status] Notifying branch build status: %s %s%n", status.getStatus(), status.getDescription());
            hash = ((BranchSCMRevision)revision).getHash();
        } else if (revision instanceof MergeRequestSCMRevision) {
            listener.getLogger().format("[GitLab Pipeline Status] Notifying merge request build status: %s %s%n", status.getStatus(), status.getDescription());
            hash = ((MergeRequestSCMRevision)revision).getOrigin().getHash();
        } else if (revision instanceof GitTagSCMRevision) {
            listener.getLogger().format("[GitLab Pipeline Status] Notifying tag build status: %s %s%n", status.getStatus(), status.getDescription());
            hash = ((GitTagSCMRevision)revision).getHash();
        } else {
            return;
        }
        try {
            EnvVars envVars = build.getEnvironment(listener);
            status.setName(GitLabPipelineStatusNotifier.getStatusName(sourceContext, build, envVars, revision));
            status.setRef(GitLabPipelineStatusNotifier.getRevisionRef(revision));
            JobScheduledListener jsl = (JobScheduledListener)((Object)ExtensionList.lookup(QueueListener.class).get(JobScheduledListener.class));
            if (jsl != null) {
                Map<Job, Long> map = jsl.resolving;
                synchronized (map) {
                    jsl.resolving.remove(build.getParent());
                }
            }
            try {
                GitLabApi gitLabApi = GitLabHelper.apiBuilder((AccessControlled)build.getParent(), source.getServerName());
                LOGGER.log(Level.FINE, String.format("Notifiying commit: %s", hash));
                if (revision instanceof MergeRequestSCMRevision) {
                    Long projectId = GitLabPipelineStatusNotifier.getSourceProjectId(build.getParent(), gitLabApi, source.getProjectPath());
                    status.setRef(((MergeRequestSCMRevision)revision).getOrigin().getHead().getName());
                    gitLabApi.getCommitsApi().addCommitStatus((Object)projectId, hash, state, status);
                } else {
                    gitLabApi.getCommitsApi().addCommitStatus((Object)source.getProjectPath(), hash, state, status);
                }
                listener.getLogger().format("[GitLab Pipeline Status] Notified%n", new Object[0]);
            }
            catch (GitLabApiException e) {
                if (!e.getMessage().contains("Cannot transition status")) {
                    LOGGER.log(Level.WARNING, String.format("Exception caught: %s", e.getMessage()));
                }
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.INFO, "Could not send status notification for " + build.getFullDisplayName() + " to " + source.getServerName(), e);
        }
    }

    @Extension
    public static class JobCompletedListener
    extends RunListener<Run<?, ?>> {
        public void onCompleted(Run<?, ?> build, @NonNull TaskListener listener) {
            LOGGER.log(Level.FINE, String.format("RunListener: Complete > %s", build.getFullDisplayName()));
            GitLabPipelineStatusNotifier.sendNotifications(build, listener, true);
            GitLabPipelineStatusNotifier.logComment(build, listener);
        }

        public void onStarted(Run<?, ?> run, TaskListener listener) {
            LOGGER.log(Level.FINE, String.format("RunListener: Started > %s", run.getFullDisplayName()));
            GitLabPipelineStatusNotifier.sendNotifications(run, listener, false);
        }
    }

    @Extension
    public static class JobCheckOutListener
    extends SCMListener {
        public void onCheckout(Run<?, ?> build, SCM scm, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState pollingBaseline) {
            LOGGER.log(Level.FINE, String.format("SCMListener: Checkout > %s", build.getFullDisplayName()));
            GitLabPipelineStatusNotifier.sendNotifications(build, listener, false);
        }
    }

    @Extension
    public static class JobScheduledListener
    extends QueueListener {
        private final AtomicLong nonce = new AtomicLong();
        private final Map<Job, Long> resolving = new HashMap<Job, Long>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEnterWaiting(Queue.WaitingItem wi) {
            if (!(wi.task instanceof Job)) {
                return;
            }
            Job job = (Job)wi.task;
            LOGGER.log(Level.FINE, String.format("QueueListener: Waiting > %s", job.getFullDisplayName()));
            SCMSource src = SCMSource.SourceByItem.findSource((Item)job);
            if (!(src instanceof GitLabSCMSource)) {
                return;
            }
            GitLabSCMSource source = (GitLabSCMSource)src;
            GitLabSCMSourceContext sourceContext = (GitLabSCMSourceContext)new GitLabSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(source.getTraits());
            if (sourceContext.notificationsDisabled()) {
                return;
            }
            SCMHead head = SCMHead.HeadByItem.findHead((Item)job);
            if (head == null) {
                return;
            }
            Long nonce = this.nonce.incrementAndGet();
            Map<Job, Long> map = this.resolving;
            synchronized (map) {
                this.resolving.put(job, nonce);
            }
            Computer.threadPoolForRemoting.submit(() -> {
                try (ACLContext ctx = ACL.as((Authentication)Tasks.getAuthenticationOf((Queue.Task)wi.task));){
                    String url;
                    String hash;
                    LogTaskListener listener = new LogTaskListener(LOGGER, Level.INFO);
                    SCMRevision revision = source.fetch(head, (TaskListener)listener);
                    CommitStatus status = new CommitStatus();
                    if (revision instanceof BranchSCMRevision) {
                        LOGGER.log(Level.INFO, "Notifying branch pending build {0}", job.getFullName());
                        hash = ((BranchSCMRevision)revision).getHash();
                    } else if (revision instanceof MergeRequestSCMRevision) {
                        LOGGER.log(Level.INFO, "Notifying merge request pending build {0}", job.getFullName());
                        hash = ((MergeRequestSCMRevision)revision).getOrigin().getHash();
                    } else {
                        if (!(revision instanceof GitTagSCMRevision)) return;
                        LOGGER.log(Level.INFO, "Notifying tag pending build {0}", job.getFullName());
                        hash = ((GitTagSCMRevision)revision).getHash();
                    }
                    Computer c = Computer.currentComputer();
                    Node n = c == null ? null : c.getNode();
                    EnvVars envVars = job.getEnvironment(n, (TaskListener)listener);
                    status.setName(GitLabPipelineStatusNotifier.getStatusName(sourceContext, job, envVars, revision));
                    status.setRef(GitLabPipelineStatusNotifier.getRevisionRef(revision));
                    try {
                        url = DisplayURLProvider.get().getJobURL(job);
                    }
                    catch (IllegalStateException e) {
                        if (ctx == null) return;
                        ctx.close();
                        return;
                    }
                    status.setTargetUrl(url);
                    status.setDescription(job.getFullName() + ": Build queued...");
                    status.setStatus("PENDING");
                    Constants.CommitBuildState state = Constants.CommitBuildState.PENDING;
                    try {
                        GitLabApi gitLabApi = GitLabHelper.apiBuilder((AccessControlled)job, source.getServerName());
                        Map<Job, Long> map = this.resolving;
                        // MONITORENTER : map
                        if (!nonce.equals(this.resolving.get(job))) {
                            LOGGER.log(Level.INFO, "{0} has already started, skipping notification of queued", job.getFullName());
                            // MONITOREXIT : map
                            return;
                        }
                        this.resolving.remove(job);
                        // MONITOREXIT : map
                        if (revision instanceof MergeRequestSCMRevision) {
                            Long projectId = GitLabPipelineStatusNotifier.getSourceProjectId(job, gitLabApi, source.getProjectPath());
                            status.setRef(((MergeRequestSCMRevision)revision).getOrigin().getHead().getName());
                            gitLabApi.getCommitsApi().addCommitStatus((Object)projectId, hash, state, status);
                        } else {
                            gitLabApi.getCommitsApi().addCommitStatus((Object)source.getProjectPath(), hash, state, status);
                        }
                        LOGGER.log(Level.INFO, "{0} Notified", job.getFullName());
                        return;
                    }
                    catch (GitLabApiException e) {
                        if (e.getMessage().contains("Cannot transition status")) return;
                        LOGGER.log(Level.WARNING, String.format("Exception caught: %s", e.getMessage()));
                        return;
                    }
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.log(Level.INFO, "Could not send commit status notification for " + job.getFullName() + " to " + source.getServerName(), e);
                }
            });
        }
    }
}

