/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource.helpers;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.gitlabbranchsource.helpers.GitLabGroup;
import io.jenkins.plugins.gitlabbranchsource.helpers.GitLabUser;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.models.Group;
import org.gitlab4j.api.models.User;

public abstract class GitLabOwner {
    private String name;
    private String webUrl;
    private String avatarUrl;
    private Long id;

    public GitLabOwner(String name, String webUrl, String avatarUrl, Long id) {
        this.name = name;
        this.webUrl = webUrl;
        this.avatarUrl = avatarUrl;
        this.id = id;
    }

    @NonNull
    public static GitLabOwner fetchOwner(GitLabApi gitLabApi, String projectOwner) {
        try {
            Group group = gitLabApi.getGroupApi().getGroup((Object)projectOwner);
            return new GitLabGroup(group.getName(), group.getWebUrl(), group.getAvatarUrl(), group.getId(), group.getFullName(), group.getDescription());
        }
        catch (GitLabApiException e) {
            if (e.getHttpStatus() != 404) {
                throw new IllegalStateException("Unable to fetch Group", e);
            }
            try {
                User user = gitLabApi.getUserApi().getUser(projectOwner);
                if (user == null) {
                    throw new IllegalStateException(String.format("Owner '%s' is neither a user/group/subgroup", projectOwner));
                }
                return new GitLabUser(user.getName(), user.getWebUrl(), user.getAvatarUrl(), user.getId());
            }
            catch (GitLabApiException e1) {
                throw new IllegalStateException("Unable to fetch User", e1);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullName() {
        return this.name;
    }

    public String getWebUrl() {
        return this.webUrl;
    }

    public void setWebUrl(String webUrl) {
        this.webUrl = webUrl;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public abstract String getWord();
}

