/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource.helpers;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import jenkins.model.Jenkins;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.lang.StringUtils;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.stapler.Stapler;

public class GitLabLink
implements Action,
IconSpec {
    @NonNull
    private final String iconClassName;
    @NonNull
    private final String url;
    private String displayName;

    public GitLabLink(@NonNull String iconClassName, @NonNull String url) {
        this.iconClassName = iconClassName;
        this.url = url;
        this.displayName = "";
    }

    public GitLabLink(@NonNull String iconClassName, @NonNull String url, String displayName) {
        this.iconClassName = iconClassName;
        this.url = url;
        this.displayName = displayName;
    }

    public static GitLabLink toGroup(String url) {
        return new GitLabLink("gitlab-logo", url, "Group");
    }

    public static GitLabLink toProject(String url) {
        return new GitLabLink("gitlab-project", url, "Project");
    }

    public static GitLabLink toBranch(String url) {
        return new GitLabLink("gitlab-branch", url, "Branch");
    }

    public static GitLabLink toMergeRequest(String url) {
        return new GitLabLink("gitlab-mr", url, "Merge Request");
    }

    public static GitLabLink toTag(String url) {
        return new GitLabLink("gitlab-tag", url, "Tag");
    }

    public static GitLabLink toCommit(String url) {
        return new GitLabLink("gitlab-commit", url, "Commit");
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    @NonNull
    public String getIconClassName() {
        return this.iconClassName;
    }

    public String getIconFileName() {
        String iconClassName = this.getIconClassName();
        Icon icon = IconSet.icons.getIconByClassSpec((Object)(iconClassName + " icon-md"));
        if (icon != null) {
            JellyContext ctx = new JellyContext();
            ctx.setVariable("resURL", (Object)(Stapler.getCurrentRequest().getContextPath() + Jenkins.RESOURCE_PATH));
            return icon.getQualifiedUrl(ctx);
        }
        return null;
    }

    public String getDisplayName() {
        return StringUtils.defaultIfBlank((String)this.displayName, (String)"GitLab");
    }

    public void setDisplayName(@NonNull String displayName) {
        this.displayName = displayName;
    }

    public String getUrlName() {
        return this.url;
    }

    public int hashCode() {
        int result = this.iconClassName.hashCode();
        result = 31 * result + this.url.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitLabLink that = (GitLabLink)o;
        if (!this.iconClassName.equals(that.iconClassName)) {
            return false;
        }
        return this.url.equals(that.url);
    }

    public String toString() {
        return "GitLabLink{iconClassName='" + this.iconClassName + "', url='" + this.url + "'}";
    }
}

