/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSource;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSourceContext;
import io.jenkins.plugins.gitlabbranchsource.Messages;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class TriggerMRCommentTrait
extends SCMSourceTrait {
    private final String commentBody;
    private final boolean onlyTrustedMembersCanTrigger;

    @DataBoundConstructor
    public TriggerMRCommentTrait(String commentBody, boolean onlyTrustedMembersCanTrigger) {
        this.commentBody = commentBody;
        this.onlyTrustedMembersCanTrigger = onlyTrustedMembersCanTrigger;
    }

    public String getCommentBody() {
        if (this.commentBody == null || this.commentBody.isEmpty()) {
            return "^REBUILD$";
        }
        return this.commentBody;
    }

    public boolean getOnlyTrustedMembersCanTrigger() {
        return this.onlyTrustedMembersCanTrigger;
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        GitLabSCMSourceContext ctx = (GitLabSCMSourceContext)context;
        ctx.withMRCommentTriggerEnabled(true);
        ctx.withOnlyTrustedMembersCanTrigger(this.getOnlyTrustedMembersCanTrigger());
        ctx.withCommentBody(this.getCommentBody());
    }

    @Extension
    @Symbol(value={"mrTriggerComment"})
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.TriggerMRCommentTrait_displayName();
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return GitLabSCMSourceContext.class;
        }

        public Class<? extends SCMSource> getSourceClass() {
            return GitLabSCMSource.class;
        }
    }
}

