/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import hudson.triggers.SCMTrigger;
import io.jenkins.plugins.gitlabbranchsource.Cause.GitLabMergeRequestCauseData;
import io.jenkins.plugins.gitlabbranchsource.Cause.GitLabPushCauseData;
import io.jenkins.plugins.gitlabbranchsource.Cause.GitLabTagPushCauseData;
import io.jenkins.plugins.gitlabbranchsource.Messages;
import org.apache.commons.lang.StringUtils;
import org.gitlab4j.api.webhook.MergeRequestEvent;
import org.gitlab4j.api.webhook.PushEvent;
import org.gitlab4j.api.webhook.TagPushEvent;

public class GitLabWebHookCause
extends SCMTrigger.SCMTriggerCause {
    private String description;
    private GitLabPushCauseData gitLabPushCauseData;
    private GitLabMergeRequestCauseData gitLabMergeRequestCauseData;
    private GitLabTagPushCauseData gitLabTagPushCauseData;

    public GitLabWebHookCause() {
        super("");
    }

    public GitLabWebHookCause fromPush(PushEvent pushEvent) {
        String userName = pushEvent.getUserName();
        this.description = StringUtils.isBlank((String)userName) ? Messages.GitLabWebHookCause_ShortDescription_Push_noUser() : Messages.GitLabWebHookCause_ShortDescription_Push(userName);
        this.gitLabPushCauseData = new GitLabPushCauseData(pushEvent);
        return this;
    }

    public GitLabWebHookCause fromMergeRequest(MergeRequestEvent mergeRequestEvent) {
        String targetNameSpace;
        MergeRequestEvent.ObjectAttributes objectAttributes = mergeRequestEvent.getObjectAttributes();
        String id = String.valueOf(objectAttributes.getIid());
        String sourceNameSpace = objectAttributes.getSource().getNamespace();
        Object nameSpace = StringUtils.equals((String)sourceNameSpace, (String)(targetNameSpace = objectAttributes.getTarget().getNamespace())) ? "" : sourceNameSpace + "/";
        String source = String.format("%s%s", nameSpace, objectAttributes.getSourceBranch());
        this.description = Messages.GitLabWebHookCause_ShortDescription_MergeRequestHook(id, source, objectAttributes.getTargetBranch());
        this.gitLabMergeRequestCauseData = new GitLabMergeRequestCauseData(mergeRequestEvent);
        return this;
    }

    public GitLabWebHookCause fromTag(TagPushEvent tagPushEvent) {
        String userName = tagPushEvent.getUserName();
        this.description = StringUtils.isBlank((String)userName) ? Messages.GitLabWebHookCause_ShortDescription_Push_noUser() : Messages.GitLabWebHookCause_ShortDescription_Push(userName);
        this.gitLabTagPushCauseData = new GitLabTagPushCauseData(tagPushEvent);
        return this;
    }

    public String getShortDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        return o instanceof GitLabWebHookCause;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public GitLabPushCauseData getGitLabPushCauseData() {
        return this.gitLabPushCauseData;
    }

    public GitLabMergeRequestCauseData getGitLabMergeRequestCauseData() {
        return this.gitLabMergeRequestCauseData;
    }

    public GitLabTagPushCauseData getGitLabTagPushCauseData() {
        return this.gitLabTagPushCauseData;
    }
}

