/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.gitlabbranchsource.AbstractGitLabSCMHeadEvent;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMNavigator;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSource;
import io.jenkins.plugins.gitlabbranchsource.GitLabTagSCMHead;
import io.jenkins.plugins.gitlabbranchsource.GitLabWebHookCause;
import java.util.Collections;
import java.util.Map;
import jenkins.plugins.git.GitTagSCMHead;
import jenkins.plugins.git.GitTagSCMRevision;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import org.gitlab4j.api.webhook.EventCommit;
import org.gitlab4j.api.webhook.TagPushEvent;

public class GitLabTagPushSCMEvent
extends AbstractGitLabSCMHeadEvent<TagPushEvent> {
    public GitLabTagPushSCMEvent(TagPushEvent tagPushEvent, String origin) {
        super(GitLabTagPushSCMEvent.typeOf(tagPushEvent), tagPushEvent, origin);
    }

    public String descriptionFor(@NonNull SCMNavigator navigator) {
        return this.description();
    }

    @NonNull
    public String getSourceName() {
        return ((TagPushEvent)this.getPayload()).getProject().getPathWithNamespace();
    }

    public String descriptionFor(SCMSource source) {
        String ref = ((TagPushEvent)this.getPayload()).getRef();
        ref = ref.startsWith("refs/tags/") ? ref.substring("refs/tags/".length()) : ref;
        return "Tag push event of tag " + ref + " in project " + ((TagPushEvent)this.getPayload()).getProject().getPathWithNamespace();
    }

    @Override
    public boolean isMatch(@NonNull GitLabSCMNavigator navigator) {
        return navigator.getNavigatorProjects().contains(((TagPushEvent)this.getPayload()).getProject().getPathWithNamespace());
    }

    @Override
    public boolean isMatch(@NonNull GitLabSCMSource source) {
        return ((TagPushEvent)this.getPayload()).getProject().getId().equals(source.getProjectId());
    }

    @Override
    @NonNull
    public Map<SCMHead, SCMRevision> headsFor(GitLabSCMSource source) {
        String ref = ((TagPushEvent)this.getPayload()).getRef();
        ref = ref.startsWith("refs/tags/") ? ref.substring("refs/tags/".length()) : ref;
        long time = 0L;
        if (this.getType() == SCMEvent.Type.CREATED) {
            time = ((EventCommit)((TagPushEvent)this.getPayload()).getCommits().get(0)).getTimestamp().getTime();
        }
        GitLabTagSCMHead h = new GitLabTagSCMHead(ref, time);
        String hash = ((TagPushEvent)this.getPayload()).getCheckoutSha();
        return Collections.singletonMap(h, this.getType() == SCMEvent.Type.CREATED ? new GitTagSCMRevision((GitTagSCMHead)h, hash) : null);
    }

    @Override
    public GitLabWebHookCause getCause() {
        return new GitLabWebHookCause().fromTag((TagPushEvent)this.getPayload());
    }
}

