/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import hudson.security.csrf.CrumbExclusion;
import hudson.util.HttpResponses;
import io.jenkins.plugins.gitlabbranchsource.GitLabSystemHookListener;
import io.jenkins.plugins.gitlabserverconfig.servers.GitLabServer;
import io.jenkins.plugins.gitlabserverconfig.servers.GitLabServers;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.scm.api.SCMEvent;
import org.apache.commons.lang.StringUtils;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.systemhooks.SystemHookListener;
import org.gitlab4j.api.systemhooks.SystemHookManager;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public final class GitLabSystemHookAction
extends CrumbExclusion
implements UnprotectedRootAction {
    public static final Logger LOGGER = Logger.getLogger(GitLabSystemHookAction.class.getName());

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "gitlab-systemhook";
    }

    public boolean process(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String pathInfo = req.getPathInfo();
        if (pathInfo != null && pathInfo.startsWith("/" + this.getUrlName() + "/post")) {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return true;
        }
        return false;
    }

    public HttpResponse doPost(StaplerRequest request) throws GitLabApiException {
        if (!request.getMethod().equals("POST")) {
            return HttpResponses.error((int)400, (String)("Only POST requests are supported, this was a " + request.getMethod() + " request"));
        }
        if (!"application/json".equals(request.getContentType())) {
            return HttpResponses.error((int)400, (String)("Only application/json content is supported, this was " + request.getContentType()));
        }
        String type = request.getHeader("X-Gitlab-Event");
        if (StringUtils.isBlank((String)type)) {
            return HttpResponses.error((int)400, (String)"Expecting a GitLab event, missing expected X-Gitlab-Event header");
        }
        String secretToken = request.getHeader("X-Gitlab-Token");
        if (!this.isValidToken(secretToken)) {
            return HttpResponses.error((int)401, (String)"Expecting a valid secret token");
        }
        String origin = SCMEvent.originOf((HttpServletRequest)request);
        SystemHookManager systemHookManager = new SystemHookManager();
        systemHookManager.addListener((SystemHookListener)new GitLabSystemHookListener(origin));
        systemHookManager.handleEvent((HttpServletRequest)request);
        return HttpResponses.ok();
    }

    private boolean isValidToken(String secretToken) {
        try {
            List<GitLabServer> servers = GitLabServers.get().getServers();
            for (GitLabServer server : servers) {
                String secretTokenAsPlainText = server.getSecretTokenAsPlainText();
                if (!Objects.equals(secretToken, secretTokenAsPlainText) && (secretTokenAsPlainText == null || !secretTokenAsPlainText.isEmpty() || secretToken != null)) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, String.format("Error while validating token: %s", e.getMessage()));
        }
        return false;
    }
}

