/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSource;
import jenkins.scm.api.trait.SCMSourceBuilder;

public class GitLabSCMSourceBuilder
extends SCMSourceBuilder<GitLabSCMSourceBuilder, GitLabSCMSource> {
    @CheckForNull
    private final String id;
    @CheckForNull
    private final String serverName;
    @CheckForNull
    private final String credentialsId;
    @NonNull
    private final String projectOwner;
    @NonNull
    private final String projectPath;
    @NonNull
    private final String projectName;

    public GitLabSCMSourceBuilder(@CheckForNull String id, @CheckForNull String serverName, @CheckForNull String credentialsId, @NonNull String projectOwner, @NonNull String projectPath, @NonNull String projectName) {
        super(GitLabSCMSource.class, projectName);
        this.id = id;
        this.serverName = serverName;
        this.credentialsId = credentialsId;
        this.projectOwner = projectOwner;
        this.projectPath = projectPath;
        this.projectName = projectName;
    }

    @CheckForNull
    public String getId() {
        return this.id;
    }

    @CheckForNull
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @NonNull
    public GitLabSCMSource build() {
        GitLabSCMSource result = new GitLabSCMSource(this.serverName, this.projectOwner, this.projectPath);
        result.setId(this.id);
        result.setCredentialsId(this.credentialsId);
        result.setTraits(this.traits());
        result.setProjectName(this.projectName);
        return result;
    }
}

