/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.gitlabbranchsource.AbstractGitLabSCMHeadEvent;
import io.jenkins.plugins.gitlabbranchsource.BranchDiscoveryTrait;
import io.jenkins.plugins.gitlabbranchsource.BranchSCMHead;
import io.jenkins.plugins.gitlabbranchsource.BranchSCMRevision;
import io.jenkins.plugins.gitlabbranchsource.ForkMergeRequestDiscoveryTrait;
import io.jenkins.plugins.gitlabbranchsource.GitLabHookCreator;
import io.jenkins.plugins.gitlabbranchsource.GitLabHookRegistration;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMBuilder;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMCauseAction;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMFileSystem;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMNavigatorContext;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSourceContext;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSourceRequest;
import io.jenkins.plugins.gitlabbranchsource.GitLabTagSCMHead;
import io.jenkins.plugins.gitlabbranchsource.MergeRequestSCMHead;
import io.jenkins.plugins.gitlabbranchsource.MergeRequestSCMRevision;
import io.jenkins.plugins.gitlabbranchsource.Messages;
import io.jenkins.plugins.gitlabbranchsource.OriginMergeRequestDiscoveryTrait;
import io.jenkins.plugins.gitlabbranchsource.WebhookListenerBuildConditionsTrait;
import io.jenkins.plugins.gitlabbranchsource.helpers.GitLabAvatar;
import io.jenkins.plugins.gitlabbranchsource.helpers.GitLabHelper;
import io.jenkins.plugins.gitlabbranchsource.helpers.GitLabLink;
import io.jenkins.plugins.gitlabserverconfig.credentials.PersonalAccessToken;
import io.jenkins.plugins.gitlabserverconfig.servers.GitLabServer;
import io.jenkins.plugins.gitlabserverconfig.servers.GitLabServers;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitTagSCMHead;
import jenkins.plugins.git.GitTagSCMRevision;
import jenkins.plugins.git.traits.GitBrowserSCMSourceTrait;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMProbe;
import jenkins.scm.api.SCMProbeStat;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceEvent;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.metadata.ContributorMetadataAction;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.api.metadata.PrimaryInstanceMetadataAction;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.mixin.ChangeRequestSCMHead2;
import jenkins.scm.api.trait.SCMHeadAuthority;
import jenkins.scm.api.trait.SCMNavigatorTraitDescriptor;
import jenkins.scm.api.trait.SCMSourceRequest;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMTraitDescriptor;
import jenkins.scm.impl.ChangeRequestSCMHeadCategory;
import jenkins.scm.impl.TagSCMHeadCategory;
import jenkins.scm.impl.UncategorizedSCMHeadCategory;
import jenkins.scm.impl.form.NamedArrayList;
import jenkins.scm.impl.trait.Discovery;
import jenkins.scm.impl.trait.Selection;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.models.AccessLevel;
import org.gitlab4j.api.models.Branch;
import org.gitlab4j.api.models.Member;
import org.gitlab4j.api.models.MergeRequest;
import org.gitlab4j.api.models.Project;
import org.gitlab4j.api.models.ProjectFilter;
import org.gitlab4j.api.models.Tag;
import org.jenkins.ui.icon.IconSpec;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class GitLabSCMSource
extends AbstractGitSCMSource {
    public static final Logger LOGGER = Logger.getLogger(GitLabSCMSource.class.getName());
    private final String serverName;
    private final String projectOwner;
    private final String projectPath;
    private String projectName;
    private String credentialsId;
    private List<SCMSourceTrait> traits = new ArrayList<SCMSourceTrait>();
    private String sshRemote;
    private String httpRemote;
    private transient Project gitlabProject;
    private long projectId;
    @NonNull
    private transient Map<Long, ObjectMetadataAction> mergeRequestMetadataCache = new ConcurrentHashMap<Long, ObjectMetadataAction>();
    @NonNull
    private transient Map<Long, ContributorMetadataAction> mergeRequestContributorCache = new ConcurrentHashMap<Long, ContributorMetadataAction>();

    @DataBoundConstructor
    public GitLabSCMSource(String serverName, String projectOwner, String projectPath) {
        this.serverName = serverName;
        this.projectOwner = projectOwner;
        this.projectPath = projectPath;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getProjectOwner() {
        return this.projectOwner;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public String getHttpRemote() {
        return this.httpRemote;
    }

    public void setHttpRemote(String httpRemote) {
        this.httpRemote = httpRemote;
    }

    public String getSshRemote() {
        return this.sshRemote;
    }

    public void setSshRemote(String sshRemote) {
        this.sshRemote = sshRemote;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getRemote() {
        return GitLabSCMBuilder.checkoutUriTemplate((Item)this.getOwner(), GitLabHelper.getServerUrlFromName(this.serverName), this.getHttpRemote(), this.getSshRemote(), this.getCredentialsId(), this.projectPath).expand();
    }

    protected Project getGitlabProject() {
        if (this.gitlabProject == null) {
            this.getGitlabProject(GitLabHelper.apiBuilder((AccessControlled)this.getOwner(), this.serverName));
        }
        return this.gitlabProject;
    }

    protected Project getGitlabProject(GitLabApi gitLabApi) {
        if (this.gitlabProject == null) {
            try {
                this.gitlabProject = gitLabApi.getProjectApi().getProject((Object)this.projectPath);
                this.sshRemote = this.gitlabProject.getSshUrlToRepo();
                this.httpRemote = this.gitlabProject.getHttpUrlToRepo();
                this.projectId = this.gitlabProject.getId();
            }
            catch (GitLabApiException e) {
                throw new IllegalStateException("Failed to retrieve project " + this.projectPath, e);
            }
        }
        return this.gitlabProject;
    }

    public HashMap<String, AccessLevel> getMembers() {
        HashMap<String, AccessLevel> members = new HashMap<String, AccessLevel>();
        try {
            GitLabApi gitLabApi = GitLabHelper.apiBuilder((AccessControlled)this.getOwner(), this.serverName);
            for (Member m : gitLabApi.getProjectApi().getAllMembers((Object)this.projectPath)) {
                members.put(m.getUsername(), m.getAccessLevel());
            }
        }
        catch (GitLabApiException e) {
            LOGGER.log(Level.WARNING, "Exception while fetching members" + e, e);
            return new HashMap<String, AccessLevel>();
        }
        return members;
    }

    public long getProjectId() {
        return this.projectId;
    }

    @DataBoundSetter
    public void setProjectId(long projectId) {
        this.projectId = projectId;
    }

    @NonNull
    public List<SCMSourceTrait> getTraits() {
        return Collections.unmodifiableList(this.traits);
    }

    @DataBoundSetter
    public void setTraits(List<SCMSourceTrait> traits) {
        this.traits = new ArrayList<SCMSourceTrait>(Util.fixNull(traits));
    }

    protected SCMRevision retrieve(@NonNull SCMHead head, @NonNull TaskListener listener) throws IOException, InterruptedException {
        try {
            GitLabApi gitLabApi = GitLabHelper.apiBuilder((AccessControlled)this.getOwner(), this.serverName);
            this.getGitlabProject(gitLabApi);
            if (head instanceof BranchSCMHead) {
                listener.getLogger().format("Querying the current revision of branch %s...%n", head.getName());
                String revision = gitLabApi.getRepositoryApi().getBranch((Object)this.gitlabProject, head.getName()).getCommit().getId();
                listener.getLogger().format("Current revision of branch %s is %s%n", head.getName(), revision);
                return new BranchSCMRevision((BranchSCMHead)head, revision);
            }
            if (head instanceof MergeRequestSCMHead) {
                MergeRequestSCMHead h = (MergeRequestSCMHead)head;
                listener.getLogger().format("Querying the current revision of merge request #%s...%n", h.getId());
                MergeRequest mr = gitLabApi.getMergeRequestApi().getMergeRequest((Object)this.gitlabProject, Long.valueOf(Long.parseLong(h.getId())));
                String targetSha = gitLabApi.getRepositoryApi().getBranch((Object)mr.getTargetProjectId(), mr.getTargetBranch()).getCommit().getId();
                if (mr.getState().equals(Constants.MergeRequestState.OPENED.toString())) {
                    listener.getLogger().format("Current revision of merge request #%s is %s%n", h.getId(), mr.getSha());
                    return new MergeRequestSCMRevision(h, new BranchSCMRevision(h.getTarget(), targetSha), new BranchSCMRevision(new BranchSCMHead(h.getOriginName()), mr.getSha()));
                }
                listener.getLogger().format("Merge request #%s is CLOSED%n", h.getId());
                return null;
            }
            if (head instanceof GitLabTagSCMHead) {
                listener.getLogger().format("Querying the current revision of tag %s...%n", head.getName());
                String revision = gitLabApi.getTagsApi().getTag((Object)this.gitlabProject, head.getName()).getCommit().getId();
                listener.getLogger().format("Current revision of tag %s is %s%n", head.getName(), revision);
                return new GitTagSCMRevision((GitTagSCMHead)((GitLabTagSCMHead)head), revision);
            }
            listener.getLogger().format("Unknown head: %s of type %s%n", head.getName(), head.getClass().getName());
            return null;
        }
        catch (GitLabApiException e) {
            LOGGER.log(Level.WARNING, "Exception caught:" + e, e);
            throw new IOException("Failed to retrieve the SCM revision for " + head.getName(), e);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void retrieve(SCMSourceCriteria criteria, @NonNull SCMHeadObserver observer, SCMHeadEvent<?> event, final @NonNull TaskListener listener) throws IOException, InterruptedException {
        try {
            gitLabApi = GitLabHelper.apiBuilder((AccessControlled)this.getOwner(), this.serverName);
            this.getGitlabProject(gitLabApi);
            ctx = new GitLabSCMSourceContext(criteria, observer);
            request = ((GitLabSCMSourceContext)ctx.withTraits(this.getTraits())).newRequest((SCMSource)this, listener);
            try {
                block37: {
                    request.setGitLabApi(gitLabApi);
                    request.setProject(this.gitlabProject);
                    request.setMembers(this.getMembers());
                    if (request.isFetchBranches()) {
                        request.setBranches(gitLabApi.getRepositoryApi().getBranches((Object)this.gitlabProject));
                    }
                    if (request.isFetchMRs() && this.gitlabProject.getMergeRequestsEnabled().booleanValue()) {
                        if (this.gitlabProject.getForkedFromProject() == null) {
                            listener.getLogger().format("%nUnable to detect if it is a mirror or not still fetching MRs anyway...%n", new Object[0]);
                            mrs /* !! */  = gitLabApi.getMergeRequestApi().getMergeRequests((Object)this.gitlabProject, Constants.MergeRequestState.OPENED);
                            mrs /* !! */  = mrs /* !! */ .stream().filter((Predicate<MergeRequest>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$retrieve$0(org.gitlab4j.api.models.MergeRequest ), (Lorg/gitlab4j/api/models/MergeRequest;)Z)()).collect(Collectors.toList());
                            request.setMergeRequests(mrs /* !! */ );
                        } else if (ctx.buildMRForksNotMirror()) {
                            listener.getLogger().format("%nCollecting MRs for fork except those that target its upstream...%n", new Object[0]);
                            mrs /* !! */  = gitLabApi.getMergeRequestApi().getMergeRequests((Object)this.gitlabProject, Constants.MergeRequestState.OPENED);
                            mrs /* !! */  = mrs /* !! */ .stream().filter((Predicate<MergeRequest>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$retrieve$1(org.gitlab4j.api.models.MergeRequest ), (Lorg/gitlab4j/api/models/MergeRequest;)Z)((GitLabSCMSource)this)).collect(Collectors.toList());
                            request.setMergeRequests(mrs /* !! */ );
                        } else {
                            listener.getLogger().format("%nIgnoring merge requests as project is a mirror...%n", new Object[0]);
                        }
                    }
                    if (request.isFetchTags()) {
                        request.setTags(gitLabApi.getTagsApi().getTags((Object)this.gitlabProject));
                    }
                    if (request.isFetchBranches()) {
                        count = 0;
                        listener.getLogger().format("%nChecking branches.. %n", new Object[0]);
                        branches = request.getBranches();
                        for (Branch branch : branches) {
                            ++count;
                            branchName = branch.getName();
                            sha = branch.getCommit().getId();
                            listener.getLogger().format("%nChecking branch %s%n", new Object[]{HyperlinkNote.encodeTo((String)GitLabHelper.branchUriTemplate(this.gitlabProject.getWebUrl()).set("branch", (Object)GitLabHelper.splitPath(branchName)).expand(), (String)branchName)});
                            if (!request.process(new BranchSCMHead(branchName), (SCMSourceRequest.RevisionLambda)LambdaMetafactory.metafactory(null, null, null, (Ljenkins/scm/api/SCMHead;)Ljenkins/scm/api/SCMRevision;, lambda$retrieve$2(java.lang.String io.jenkins.plugins.gitlabbranchsource.BranchSCMHead ), (Lio/jenkins/plugins/gitlabbranchsource/BranchSCMHead;)Lio/jenkins/plugins/gitlabbranchsource/BranchSCMRevision;)((String)sha), (SCMSourceRequest.ProbeLambda)new SCMSourceRequest.ProbeLambda<BranchSCMHead, BranchSCMRevision>(){

                                @NonNull
                                public SCMSourceCriteria.Probe create(@NonNull BranchSCMHead head, @Nullable BranchSCMRevision revision) throws IOException {
                                    return GitLabSCMSource.this.createProbe(head, (SCMRevision)revision);
                                }
                            }, new SCMSourceRequest.Witness[]{(SCMSourceRequest.Witness)LambdaMetafactory.metafactory(null, null, null, (Ljenkins/scm/api/SCMHead;Ljenkins/scm/api/SCMRevision;Z)V, lambda$retrieve$3(hudson.model.TaskListener jenkins.scm.api.SCMHead jenkins.scm.api.SCMRevision boolean ), (Ljenkins/scm/api/SCMHead;Ljenkins/scm/api/SCMRevision;Z)V)((TaskListener)listener)})) continue;
                            listener.getLogger().format("%n%d branches were processed (query completed)%n", new Object[]{count});
                            return;
                        }
                        listener.getLogger().format("%n%d branches were processed%n", new Object[]{count});
                    }
                    if (!request.isFetchMRs() || request.isComplete() || !this.gitlabProject.getMergeRequestsEnabled().booleanValue()) ** GOTO lbl85
                    count = 0;
                    listener.getLogger().format("%nChecking merge requests..%n", new Object[0]);
                    forkMrSources = new HashMap<Long, String>();
                    var10_14 = request.getMergeRequests().iterator();
                    while (true) {
                        block36: {
                            if (var10_14.hasNext()) {
                                mr = (MergeRequest)var10_14.next();
                                this.mergeRequestContributorCache.put(mr.getIid(), new ContributorMetadataAction(mr.getAuthor().getUsername(), mr.getAuthor().getName(), mr.getAuthor().getEmail()));
                                this.mergeRequestMetadataCache.put(mr.getIid(), new ObjectMetadataAction(mr.getTitle(), mr.getDescription(), mr.getWebUrl()));
                                ++count;
                                listener.getLogger().format("%nChecking merge request %s%n", new Object[]{HyperlinkNote.encodeTo((String)GitLabHelper.mergeRequestUriTemplate(this.gitlabProject.getWebUrl()).set("iid", (Object)mr.getIid()).expand(), (String)("!" + mr.getIid()))});
                                strategies = request.getMRStrategies();
                                fork = mr.getSourceProjectId().equals(mr.getTargetProjectId()) == false;
                                originOwner = mr.getAuthor().getUsername();
                                originProjectPath = this.projectPath;
                                if (fork && !forkMrSources.containsKey(mr.getSourceProjectId())) {
                                    originProjectPath = gitLabApi.getProjectApi().getProject((Object)mr.getSourceProjectId()).getPathWithNamespace();
                                    forkMrSources.put(mr.getSourceProjectId(), originProjectPath);
                                } else if (fork) {
                                    originProjectPath = (String)forkMrSources.get(mr.getSourceProjectId());
                                }
                                try {
                                    targetSha = gitLabApi.getRepositoryApi().getBranch((Object)mr.getTargetProjectId(), mr.getTargetBranch()).getCommit().getId();
                                    break block36;
                                }
                                catch (Exception e) {
                                    listener.getLogger().format("Failed getting TargetBranch from Merge Request: " + mr.getIid() + " (" + mr.getTitle() + ")%n%s", new Object[]{e});
                                    continue;
                                }
                            }
                            listener.getLogger().format("%n%d merge requests were processed%n", new Object[]{count});
lbl85:
                            // 2 sources

                            if (request.isFetchTags() == false) return;
                            count = 0;
                            listener.getLogger().format("%nChecking tags..%n", new Object[0]);
                            tags = request.getTags();
                            var10_14 = tags.iterator();
                            break block37;
                        }
                        GitLabSCMSource.LOGGER.log(Level.FINE, String.format("%s -> %s", new Object[]{originOwner, request.isMember(originOwner) != false ? "Trusted" : "Untrusted"}));
                        var17_23 = strategies.get(fork).iterator();
                        do {
                            if (!var17_23.hasNext()) ** break;
                            strategy = var17_23.next();
                        } while (!request.process(new MergeRequestSCMHead("MR-" + mr.getIid() + (String)(strategies.get(fork).size() > 1 ? "-" + strategy.name().toLowerCase(Locale.ENGLISH) : ""), mr.getIid(), new BranchSCMHead(mr.getTargetBranch()), strategy, (SCMHeadOrigin)(fork != false ? new SCMHeadOrigin.Fork(originProjectPath) : SCMHeadOrigin.DEFAULT), originOwner, originProjectPath, mr.getSourceBranch(), mr.getTitle()), (SCMSourceRequest.RevisionLambda)LambdaMetafactory.metafactory(null, null, null, (Ljenkins/scm/api/SCMHead;)Ljenkins/scm/api/SCMRevision;, lambda$retrieve$4(java.lang.String org.gitlab4j.api.models.MergeRequest io.jenkins.plugins.gitlabbranchsource.MergeRequestSCMHead ), (Lio/jenkins/plugins/gitlabbranchsource/MergeRequestSCMHead;)Lio/jenkins/plugins/gitlabbranchsource/MergeRequestSCMRevision;)((String)targetSha, (MergeRequest)mr), (SCMSourceRequest.ProbeLambda)new SCMSourceRequest.ProbeLambda<MergeRequestSCMHead, MergeRequestSCMRevision>(){

                            @NonNull
                            public SCMSourceCriteria.Probe create(@NonNull MergeRequestSCMHead head, @Nullable MergeRequestSCMRevision revision) throws IOException, InterruptedException {
                                boolean isTrusted = request.isTrusted(head);
                                if (!isTrusted) {
                                    listener.getLogger().format("(not from a trusted source)%n", new Object[0]);
                                }
                                return GitLabSCMSource.this.createProbe(isTrusted ? head : head.getTarget(), (SCMRevision)revision);
                            }
                        }, new SCMSourceRequest.Witness[]{(SCMSourceRequest.Witness)LambdaMetafactory.metafactory(null, null, null, (Ljenkins/scm/api/SCMHead;Ljenkins/scm/api/SCMRevision;Z)V, lambda$retrieve$5(hudson.model.TaskListener jenkins.scm.api.SCMHead jenkins.scm.api.SCMRevision boolean ), (Ljenkins/scm/api/SCMHead;Ljenkins/scm/api/SCMRevision;Z)V)((TaskListener)listener)}));
                        break;
                    }
                    listener.getLogger().format("%n%d merge requests were processed (query completed)%n", new Object[]{count});
                    return;
                }
                while (var10_14.hasNext()) {
                    tag = (Tag)var10_14.next();
                    ++count;
                    tagName = tag.getName();
                    tagDate = tag.getCommit().getCommittedDate().getTime();
                    sha = tag.getCommit().getId();
                    listener.getLogger().format("%nChecking tag %s%n", new Object[]{HyperlinkNote.encodeTo((String)GitLabHelper.tagUriTemplate(this.gitlabProject.getWebUrl()).set("tag", (Object)GitLabHelper.splitPath(tag.getName())).expand(), (String)tag.getName())});
                    head = new GitLabTagSCMHead(tagName, tagDate);
                    if (!request.process((SCMHead)head, (SCMRevision)new GitTagSCMRevision((GitTagSCMHead)head, sha), (SCMSourceRequest.ProbeLambda)new SCMSourceRequest.ProbeLambda<GitLabTagSCMHead, GitTagSCMRevision>(){

                        @NonNull
                        public SCMSourceCriteria.Probe create(@NonNull GitLabTagSCMHead head, @Nullable GitTagSCMRevision revision) throws IOException {
                            return GitLabSCMSource.this.createProbe((SCMHead)head, (SCMRevision)revision);
                        }
                    }, new SCMSourceRequest.Witness[]{(SCMSourceRequest.Witness)LambdaMetafactory.metafactory(null, null, null, (Ljenkins/scm/api/SCMHead;Ljenkins/scm/api/SCMRevision;Z)V, lambda$retrieve$6(hudson.model.TaskListener jenkins.scm.api.SCMHead jenkins.scm.api.SCMRevision boolean ), (Ljenkins/scm/api/SCMHead;Ljenkins/scm/api/SCMRevision;Z)V)((TaskListener)listener)})) continue;
                    listener.getLogger().format("%n%d tags were processed (query completed)%n", new Object[]{count});
                    return;
                }
                listener.getLogger().format("%n%d tags were processed (query completed)%n", new Object[]{count});
                return;
            }
            finally {
                if (request != null) {
                    request.close();
                }
            }
        }
        catch (GitLabApiException e) {
            GitLabSCMSource.LOGGER.log(Level.WARNING, "Exception caught:" + e, e);
            throw new IOException("Failed to fetch latest heads", e);
        }
        finally {
            owner = this.getOwner();
            if (owner != null) {
                owner.save();
            }
        }
    }

    protected SCMRevision retrieve(@NonNull String thingName, @NonNull TaskListener listener) throws IOException, InterruptedException {
        SCMHeadObserver.Named baptist = SCMHeadObserver.named((String)thingName);
        this.retrieve(null, (SCMHeadObserver)baptist, null, listener);
        return baptist.result();
    }

    @NonNull
    protected Set<String> retrieveRevisions(@NonNull TaskListener listener) throws IOException, InterruptedException {
        HashSet<String> revisions = new HashSet<String>();
        for (SCMHead head : this.retrieve(listener)) {
            revisions.add(head.getName());
        }
        return revisions;
    }

    @NonNull
    protected List<Action> retrieveActions(SCMSourceEvent event, @NonNull TaskListener listener) {
        ArrayList<Action> result = new ArrayList<Action>();
        this.getGitlabProject();
        GitLabSCMSourceContext ctx = (GitLabSCMSourceContext)new GitLabSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(this.traits);
        String projectUrl = this.gitlabProject.getWebUrl();
        String name = StringUtils.isBlank((String)this.projectName) ? this.gitlabProject.getNameWithNamespace() : this.projectName;
        result.add((Action)new ObjectMetadataAction(name, this.gitlabProject.getDescription(), projectUrl));
        String avatarUrl = this.gitlabProject.getAvatarUrl();
        if (!ctx.projectAvatarDisabled() && StringUtils.isNotBlank((String)avatarUrl)) {
            result.add((Action)new GitLabAvatar(avatarUrl));
        }
        result.add(GitLabLink.toProject(projectUrl));
        return result;
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMHead head, SCMHeadEvent event, @NonNull TaskListener listener) {
        this.getGitlabProject();
        ArrayList<Action> result = new ArrayList<Action>();
        if (head instanceof BranchSCMHead) {
            String branchUrl = GitLabHelper.branchUriTemplate(this.serverName).set("project", (Object)GitLabHelper.splitPath(this.projectPath)).set("branch", (Object)head.getName()).expand();
            result.add((Action)new ObjectMetadataAction(null, null, branchUrl));
            result.add(GitLabLink.toBranch(branchUrl));
            if (head.getName().equals(this.gitlabProject.getDefaultBranch())) {
                result.add((Action)new PrimaryInstanceMetadataAction());
            }
        } else if (head instanceof MergeRequestSCMHead) {
            long iid = Long.parseLong(((MergeRequestSCMHead)head).getId());
            String mergeUrl = GitLabHelper.mergeRequestUriTemplate(this.serverName).set("project", (Object)GitLabHelper.splitPath(this.projectPath)).set("iid", (Object)iid).expand();
            ObjectMetadataAction metadataAction = this.mergeRequestMetadataCache.get(iid);
            if (metadataAction == null) {
                metadataAction = new ObjectMetadataAction(null, null, mergeUrl);
            }
            result.add((Action)metadataAction);
            ContributorMetadataAction contributor = this.mergeRequestContributorCache.get(iid);
            if (contributor != null) {
                result.add((Action)contributor);
            }
            result.add(GitLabLink.toMergeRequest(mergeUrl));
        } else if (head instanceof GitLabTagSCMHead) {
            String tagUrl = GitLabHelper.tagUriTemplate(this.serverName).set("project", (Object)GitLabHelper.splitPath(this.projectPath)).set("tag", (Object)head.getName()).expand();
            result.add((Action)new ObjectMetadataAction(null, null, tagUrl));
            result.add(GitLabLink.toTag(tagUrl));
        }
        return result;
    }

    @NonNull
    public SCM build(@NonNull SCMHead head, SCMRevision revision) {
        return ((GitLabSCMBuilder)new GitLabSCMBuilder(this, head, revision).withTraits(this.traits)).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public SCMRevision getTrustedRevision(@NonNull SCMRevision revision, @NonNull TaskListener listener) {
        if (!(revision instanceof MergeRequestSCMRevision)) return revision;
        MergeRequestSCMHead head = (MergeRequestSCMHead)revision.getHead();
        try (GitLabSCMSourceRequest request = ((GitLabSCMSourceContext)new GitLabSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(this.traits)).newRequest((SCMSource)this, listener);){
            request.setMembers(this.getMembers());
            boolean isTrusted = request.isTrusted(head);
            LOGGER.log(Level.FINEST, String.format("Trusted Revision: %s -> %s", head.getOriginOwner(), isTrusted));
            if (isTrusted) {
                SCMRevision sCMRevision = revision;
                return sCMRevision;
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.SEVERE, "Exception caught: " + e, e);
        }
        MergeRequestSCMRevision rev = (MergeRequestSCMRevision)revision;
        listener.getLogger().format("Loading trusted files from target branch %s at %s rather than %s%n", head.getTarget().getName(), rev.getBaseHash(), rev.getHeadHash());
        return new AbstractGitSCMSource.SCMRevisionImpl((SCMHead)head.getTarget(), rev.getBaseHash());
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMRevision revision, SCMHeadEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (revision instanceof AbstractGitSCMSource.SCMRevisionImpl) {
            String hash = ((AbstractGitSCMSource.SCMRevisionImpl)revision).getHash();
            String commitUrl = GitLabHelper.commitUriTemplate(this.serverName).set("project", (Object)GitLabHelper.splitPath(this.projectPath)).set("hash", (Object)hash).expand();
            actions.add(GitLabLink.toCommit(commitUrl));
        }
        if (event instanceof AbstractGitLabSCMHeadEvent) {
            actions.add((Action)new GitLabSCMCauseAction(new Cause[]{((AbstractGitLabSCMHeadEvent)event).getCause()}));
        }
        return actions;
    }

    @NonNull
    protected SCMProbe createProbe(final @NonNull SCMHead head, SCMRevision revision) throws IOException {
        try {
            GitLabSCMFileSystem.BuilderImpl builder = (GitLabSCMFileSystem.BuilderImpl)((Object)ExtensionList.lookup(SCMFileSystem.Builder.class).get(GitLabSCMFileSystem.BuilderImpl.class));
            if (builder == null) {
                throw new AssertionError();
            }
            GitLabApi gitLabApi = GitLabHelper.apiBuilder((AccessControlled)this.getOwner(), this.serverName);
            this.getGitlabProject(gitLabApi);
            final SCMFileSystem fs = builder.build(head, revision, gitLabApi, this.projectPath);
            return new SCMProbe(){

                @NonNull
                public SCMProbeStat stat(@NonNull String path) throws IOException {
                    try {
                        return SCMProbeStat.fromType((SCMFile.Type)fs.child(path).getType());
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Interrupted", e);
                    }
                }

                public void close() throws IOException {
                    Objects.requireNonNull(fs).close();
                }

                public String name() {
                    return head.getName();
                }

                public long lastModified() {
                    try {
                        return fs != null ? fs.lastModified() : 0L;
                    }
                    catch (IOException | InterruptedException e) {
                        return 0L;
                    }
                }

                public SCMFile getRoot() {
                    return fs != null ? fs.getRoot() : null;
                }
            };
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public void afterSave() {
        GitLabServer server = GitLabServers.get().findServer(this.getServerName());
        if (server != null && server.isManageWebHooks()) {
            GitLabSCMSourceContext ctx = (GitLabSCMSourceContext)new GitLabSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(((GitLabSCMNavigatorContext)new GitLabSCMNavigatorContext().withTraits(this.traits)).traits());
            GitLabHookRegistration webhookMode = ctx.webhookRegistration();
            GitLabHookRegistration systemhookMode = ctx.systemhookRegistration();
            GitLabHookCreator.register(this, webhookMode, systemhookMode);
        }
    }

    public PersonalAccessToken credentials() {
        return (PersonalAccessToken)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(PersonalAccessToken.class, (Item)this.getOwner(), (Authentication)Jenkins.getAuthentication(), (List)URIRequirementBuilder.fromUri((String)GitLabHelper.getServerUrlFromName(this.serverName)).build()), (CredentialsMatcher)GitLabServer.CREDENTIALS_MATCHER);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Known to be null during deserialization")
    private Object readResolve() {
        if (this.mergeRequestMetadataCache == null) {
            this.mergeRequestMetadataCache = new ConcurrentHashMap<Long, ObjectMetadataAction>();
        }
        if (this.mergeRequestContributorCache == null) {
            this.mergeRequestContributorCache = new ConcurrentHashMap<Long, ContributorMetadataAction>();
        }
        return this;
    }

    private static /* synthetic */ void lambda$retrieve$6(TaskListener listener, SCMHead head1, SCMRevision revision, boolean isMatch) {
        if (isMatch) {
            listener.getLogger().format("Met criteria%n", new Object[0]);
        } else {
            listener.getLogger().format("Does not meet criteria%n", new Object[0]);
        }
    }

    private static /* synthetic */ void lambda$retrieve$5(TaskListener listener, SCMHead head, SCMRevision revision, boolean isMatch) {
        if (isMatch) {
            listener.getLogger().format("Met criteria%n", new Object[0]);
        } else {
            listener.getLogger().format("Does not meet criteria%n", new Object[0]);
        }
    }

    private static /* synthetic */ MergeRequestSCMRevision lambda$retrieve$4(String targetSha, MergeRequest mr, MergeRequestSCMHead head) throws IOException, InterruptedException {
        return new MergeRequestSCMRevision(head, new BranchSCMRevision(head.getTarget(), targetSha), new BranchSCMRevision(new BranchSCMHead(head.getOriginName()), mr.getSha()));
    }

    private static /* synthetic */ void lambda$retrieve$3(TaskListener listener, SCMHead head, SCMRevision revision, boolean isMatch) {
        if (isMatch) {
            listener.getLogger().format("Met criteria%n", new Object[0]);
        } else {
            listener.getLogger().format("Does not meet criteria%n", new Object[0]);
        }
    }

    private static /* synthetic */ BranchSCMRevision lambda$retrieve$2(String sha, BranchSCMHead head) throws IOException, InterruptedException {
        return new BranchSCMRevision(head, sha);
    }

    private /* synthetic */ boolean lambda$retrieve$1(MergeRequest mr) {
        return mr.getSourceProjectId() != null && !mr.getTargetProjectId().equals(this.gitlabProject.getForkedFromProject().getId());
    }

    private static /* synthetic */ boolean lambda$retrieve$0(MergeRequest mr) {
        return mr.getSourceProjectId() != null;
    }

    @Symbol(value={"gitlab"})
    @Extension
    public static class DescriptorImpl
    extends SCMSourceDescriptor
    implements IconSpec {
        public String getIconClassName() {
            return "gitlab-logo";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.GitLabSCMSource_DisplayName();
        }

        public String getPronoun() {
            return Messages.GitLabSCMSource_Pronoun();
        }

        public String getSelectedServer(@QueryParameter String serverName) {
            return serverName;
        }

        public ListBoxModel doFillServerNameItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverName) {
            if (context == null) {
                if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                    ListBoxModel result = new ListBoxModel();
                    result.add(serverName);
                    return result;
                }
            } else if (!context.hasPermission(Item.EXTENDED_READ)) {
                ListBoxModel result = new ListBoxModel();
                result.add(serverName);
                return result;
            }
            return GitLabServers.get().getServerItems();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverName, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (context == null) {
                if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                    result.includeCurrentValue(credentialsId);
                    return result;
                }
            } else if (!context.hasPermission(Item.EXTENDED_READ) && !context.hasPermission(CredentialsProvider.USE_ITEM)) {
                result.includeCurrentValue(credentialsId);
                return result;
            }
            result.includeEmptyValue();
            result.includeMatchingAs(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication() : ACL.SYSTEM, (Item)context, StandardUsernameCredentials.class, URIRequirementBuilder.fromUri((String)GitLabHelper.getServerUrlFromName(serverName)).build(), GitClient.CREDENTIALS_MATCHER);
            return result;
        }

        public long getProjectId(@AncestorInPath SCMSourceOwner context, @QueryParameter String projectPath, @QueryParameter String serverName) {
            List<GitLabServer> gitLabServers = GitLabServers.get().getServers();
            if (gitLabServers.size() == 0) {
                return -1L;
            }
            try {
                GitLabApi gitLabApi = StringUtils.isBlank((String)serverName) ? GitLabHelper.apiBuilder((AccessControlled)context, gitLabServers.get(0).getName()) : GitLabHelper.apiBuilder((AccessControlled)context, serverName);
                if (StringUtils.isNotBlank((String)projectPath)) {
                    return gitLabApi.getProjectApi().getProject((Object)projectPath).getId();
                }
            }
            catch (GitLabApiException e) {
                return -1L;
            }
            return -1L;
        }

        public ListBoxModel doFillProjectPathItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverName, @QueryParameter String projectOwner) {
            List<GitLabServer> gitLabServers = GitLabServers.get().getServers();
            if (gitLabServers.size() == 0) {
                return new StandardListBoxModel().includeEmptyValue();
            }
            ListBoxModel result = new ListBoxModel();
            try {
                GitLabApi gitLabApi = serverName.equals("") ? GitLabHelper.apiBuilder((AccessControlled)context, gitLabServers.get(0).getName()) : GitLabHelper.apiBuilder((AccessControlled)context, serverName);
                if (projectOwner.equals("")) {
                    return new StandardListBoxModel().includeEmptyValue();
                }
                try {
                    for (Project p : gitLabApi.getProjectApi().getUserProjects((Object)projectOwner, new ProjectFilter().withOwned(Boolean.valueOf(true)))) {
                        result.add(p.getPathWithNamespace());
                    }
                }
                catch (GitLabApiException e) {
                    for (Project p : gitLabApi.getGroupApi().getProjects((Object)projectOwner)) {
                        result.add(p.getPathWithNamespace());
                    }
                }
                return result;
            }
            catch (GitLabApiException e) {
                LOGGER.log(Level.WARNING, "Exception caught:" + e, e);
                return new StandardListBoxModel().includeEmptyValue();
            }
        }

        public List<NamedArrayList<? extends SCMTraitDescriptor<?>>> getTraitsDescriptorLists() {
            ArrayList all = new ArrayList();
            all.addAll(SCMSourceTrait._for((SCMSourceDescriptor)this, GitLabSCMSourceContext.class, null));
            all.addAll(SCMSourceTrait._for((SCMSourceDescriptor)this, null, GitLabSCMBuilder.class));
            HashSet<SCMTraitDescriptor> dedup = new HashSet<SCMTraitDescriptor>();
            Iterator iterator = all.iterator();
            while (iterator.hasNext()) {
                SCMTraitDescriptor d = (SCMTraitDescriptor)iterator.next();
                if (dedup.contains(d) || d instanceof GitBrowserSCMSourceTrait.DescriptorImpl) {
                    iterator.remove();
                    continue;
                }
                dedup.add(d);
            }
            ArrayList result = new ArrayList();
            NamedArrayList.select(all, (String)"Projects", (NamedArrayList.Predicate)new NamedArrayList.Predicate<SCMTraitDescriptor<?>>(){

                public boolean test(SCMTraitDescriptor<?> scmTraitDescriptor) {
                    return scmTraitDescriptor instanceof SCMNavigatorTraitDescriptor;
                }
            }, (boolean)true, result);
            NamedArrayList.select(all, (String)"Within project", (NamedArrayList.Predicate)NamedArrayList.anyOf((NamedArrayList.Predicate[])new NamedArrayList.Predicate[]{NamedArrayList.withAnnotation(Discovery.class), NamedArrayList.withAnnotation(Selection.class)}), (boolean)true, result);
            NamedArrayList.select(all, (String)"Additional", null, (boolean)true, result);
            return result;
        }

        @NonNull
        public List<SCMSourceTrait> getTraitsDefaults() {
            return Arrays.asList(new SCMSourceTrait[]{new BranchDiscoveryTrait(true, false), new OriginMergeRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE)), new ForkMergeRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE), (SCMHeadAuthority<? super GitLabSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision>)new ForkMergeRequestDiscoveryTrait.TrustPermission(), false), new WebhookListenerBuildConditionsTrait()});
        }

        @NonNull
        protected SCMHeadCategory[] createCategories() {
            return new SCMHeadCategory[]{new UncategorizedSCMHeadCategory(Messages._GitLabSCMSource_UncategorizedCategory()), new ChangeRequestSCMHeadCategory(Messages._GitLabSCMSource_ChangeRequestCategory()), new TagSCMHeadCategory(Messages._GitLabSCMSource_TagCategory())};
        }
    }
}

