/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.gitlabbranchsource.GitLabHookCreator;
import io.jenkins.plugins.gitlabbranchsource.GitLabHookRegistration;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMBuilder;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMNavigatorContext;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMNavigatorRequest;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSource;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSourceBuilder;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSourceContext;
import io.jenkins.plugins.gitlabbranchsource.helpers.GitLabAvatar;
import io.jenkins.plugins.gitlabbranchsource.helpers.GitLabGroup;
import io.jenkins.plugins.gitlabbranchsource.helpers.GitLabHelper;
import io.jenkins.plugins.gitlabbranchsource.helpers.GitLabIcons;
import io.jenkins.plugins.gitlabbranchsource.helpers.GitLabLink;
import io.jenkins.plugins.gitlabbranchsource.helpers.GitLabOwner;
import io.jenkins.plugins.gitlabbranchsource.helpers.GitLabUser;
import io.jenkins.plugins.gitlabserverconfig.credentials.helpers.GitLabCredentialMatcher;
import io.jenkins.plugins.gitlabserverconfig.servers.GitLabServer;
import io.jenkins.plugins.gitlabserverconfig.servers.GitLabServers;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import jenkins.plugins.git.traits.GitBrowserSCMSourceTrait;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMNavigatorDescriptor;
import jenkins.scm.api.SCMNavigatorEvent;
import jenkins.scm.api.SCMNavigatorOwner;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceObserver;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.api.trait.SCMNavigatorRequest;
import jenkins.scm.api.trait.SCMNavigatorTrait;
import jenkins.scm.api.trait.SCMNavigatorTraitDescriptor;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMTrait;
import jenkins.scm.api.trait.SCMTraitDescriptor;
import jenkins.scm.impl.form.NamedArrayList;
import jenkins.scm.impl.trait.Discovery;
import jenkins.scm.impl.trait.Selection;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.models.GroupProjectsFilter;
import org.gitlab4j.api.models.Project;
import org.gitlab4j.api.models.ProjectFilter;
import org.jenkins.ui.icon.IconSpec;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class GitLabSCMNavigator
extends SCMNavigator {
    public static final Logger LOGGER = Logger.getLogger(GitLabSCMNavigator.class.getName());
    private final String projectOwner;
    private String serverName;
    private String credentialsId;
    private List<SCMTrait<? extends SCMTrait<?>>> traits;
    private HashSet<String> navigatorProjects = new HashSet();
    private boolean isGroup;
    private boolean wantSubGroupProjects;
    private transient GitLabOwner gitlabOwner;

    @DataBoundConstructor
    public GitLabSCMNavigator(String projectOwner) {
        this.projectOwner = projectOwner;
        this.traits = new ArrayList();
    }

    public static String getProjectOwnerFromNamespace(String projectPathWithNamespace) {
        int namespaceLength = projectPathWithNamespace.lastIndexOf("/");
        return projectPathWithNamespace.substring(0, namespaceLength);
    }

    public HashSet<String> getNavigatorProjects() {
        return this.navigatorProjects;
    }

    public boolean isGroup() {
        return this.isGroup;
    }

    public boolean isWantSubGroupProjects() {
        return this.wantSubGroupProjects;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getServerName() {
        return this.serverName;
    }

    @DataBoundSetter
    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getProjectOwner() {
        return this.projectOwner;
    }

    @NonNull
    public List<SCMTrait<? extends SCMTrait<?>>> getTraits() {
        return Collections.unmodifiableList(this.traits);
    }

    @DataBoundSetter
    public void setTraits(@CheckForNull SCMTrait[] traits) {
        this.traits = new ArrayList();
        if (traits != null) {
            for (SCMTrait trait : traits) {
                this.traits.add(trait);
            }
        }
    }

    private GitLabOwner getGitlabOwner(SCMNavigatorOwner owner) {
        if (this.gitlabOwner == null) {
            this.getGitlabOwner(GitLabHelper.apiBuilder((AccessControlled)owner, this.serverName));
        }
        return this.gitlabOwner;
    }

    private GitLabOwner getGitlabOwner(GitLabApi gitLabApi) {
        if (this.gitlabOwner == null) {
            this.gitlabOwner = GitLabOwner.fetchOwner(gitLabApi, this.projectOwner);
        }
        return this.gitlabOwner;
    }

    public void setTraits(@CheckForNull List<SCMTrait<? extends SCMTrait<?>>> traits) {
        this.traits = traits != null ? new ArrayList(traits) : new ArrayList();
    }

    @NonNull
    protected String id() {
        return GitLabHelper.getServerUrlFromName(this.serverName) + "::" + this.projectOwner;
    }

    public void visitSources(@NonNull SCMSourceObserver observer) throws IOException, InterruptedException {
        GitLabSCMNavigatorContext context = (GitLabSCMNavigatorContext)new GitLabSCMNavigatorContext().withTraits(this.traits);
        try (GitLabSCMNavigatorRequest request = context.newRequest(this, observer);){
            List projects;
            GitLabApi gitLabApi = GitLabHelper.apiBuilder((AccessControlled)observer.getContext(), this.serverName);
            this.getGitlabOwner(gitLabApi);
            if (this.gitlabOwner instanceof GitLabUser) {
                projects = gitLabApi.getProjectApi().getUserProjects((Object)this.projectOwner, new ProjectFilter().withOwned(Boolean.valueOf(true)));
            } else {
                this.isGroup = true;
                GroupProjectsFilter groupProjectsFilter = new GroupProjectsFilter();
                this.wantSubGroupProjects = request.wantSubgroupProjects();
                groupProjectsFilter.withIncludeSubGroups(Boolean.valueOf(this.wantSubGroupProjects));
                projects = gitLabApi.getGroupApi().getProjects((Object)this.projectOwner, groupProjectsFilter);
            }
            int count = 0;
            observer.getListener().getLogger().format("%nChecking projects...%n", new Object[0]);
            StandardCredentials webHookCredentials = this.getWebHookCredentials(observer.getContext());
            GitLabApi webhookGitLabApi = null;
            String webHookUrl = null;
            if (webHookCredentials != null) {
                GitLabServer server = GitLabServers.get().findServer(this.serverName);
                String serverUrl = GitLabHelper.getServerUrl(server);
                webhookGitLabApi = new GitLabApi(serverUrl, GitLabHelper.getPrivateTokenAsPlainText(webHookCredentials), null, GitLabHelper.getProxyConfig(serverUrl));
                webHookUrl = GitLabHookCreator.getHookUrl(server, true);
            }
            for (Project p : projects) {
                ++count;
                String projectPathWithNamespace = p.getPathWithNamespace();
                String projectOwner = GitLabSCMNavigator.getProjectOwnerFromNamespace(projectPathWithNamespace);
                String projectName = this.getProjectName(gitLabApi, request.withProjectNamingStrategy(), p);
                this.getNavigatorProjects().add(projectPathWithNamespace);
                if (StringUtils.isEmpty((String)p.getDefaultBranch())) {
                    observer.getListener().getLogger().format("%nIgnoring project with empty repository %s%n", HyperlinkNote.encodeTo((String)p.getWebUrl(), (String)p.getName()));
                    continue;
                }
                if (p.getArchived().booleanValue() && context.isExcludeArchivedRepositories()) {
                    observer.getListener().getLogger().format("%nIgnoring archived project %s%n", HyperlinkNote.encodeTo((String)p.getWebUrl(), (String)p.getName()));
                    continue;
                }
                observer.getListener().getLogger().format("%nChecking project %s%n", HyperlinkNote.encodeTo((String)p.getWebUrl(), (String)projectName));
                try {
                    GitLabServer server = GitLabServers.get().findServer(this.serverName);
                    if (webhookGitLabApi != null && webHookUrl != null) {
                        String secretToken = server.getSecretTokenAsPlainText();
                        if (secretToken == null) {
                            secretToken = "";
                        }
                        observer.getListener().getLogger().format("Web hook %s%n", GitLabHookCreator.createWebHookWhenMissing(webhookGitLabApi, projectPathWithNamespace, webHookUrl, secretToken));
                    }
                }
                catch (GitLabApiException e) {
                    observer.getListener().getLogger().format("Cannot set web hook: %s%n", e.getReason());
                }
                if (!request.process(projectName, name -> ((GitLabSCMSourceBuilder)new GitLabSCMSourceBuilder(this.getId() + "::" + projectPathWithNamespace, this.serverName, this.credentialsId, projectOwner, projectPathWithNamespace, name).withTraits(this.traits)).build(), null, new SCMNavigatorRequest.Witness[]{(name, isMatch) -> {
                    if (isMatch) {
                        observer.getListener().getLogger().format("Proposing %s%n", name);
                    } else {
                        observer.getListener().getLogger().format("Ignoring %s%n", name);
                    }
                }})) continue;
                observer.getListener().getLogger().format("%n%d projects were processed (query complete)%n", count);
                return;
            }
            observer.getListener().getLogger().format("%n%d projects were processed%n", count);
        }
        catch (URISyntaxException | GitLabApiException e) {
            LOGGER.log(Level.WARNING, "Exception caught:" + (Exception)e, e);
            throw new IOException("Failed to visit SCM source", e);
        }
    }

    @NonNull
    private String getProjectName(GitLabApi gitLabApi, int projectNamingStrategy, Project project) throws URISyntaxException {
        String projectName;
        String fullPath = project.getPathWithNamespace();
        switch (projectNamingStrategy) {
            default: {
                projectName = fullPath;
                break;
            }
            case 2: {
                projectName = project.getNameWithNamespace().replace(String.format("%s / ", this.getGitlabOwner(gitLabApi).getFullName()), "");
                break;
            }
            case 3: {
                URI ownerPathUri = new URI(this.projectOwner);
                URI fullPathUri = new URI(fullPath);
                projectName = ownerPathUri.relativize(fullPathUri).toString();
                break;
            }
            case 4: {
                projectName = fullPath.substring(fullPath.lastIndexOf(47) + 1);
            }
        }
        return projectName;
    }

    private StandardCredentials getWebHookCredentials(SCMSourceOwner owner) {
        StandardCredentials credentials = null;
        GitLabServer server = GitLabServers.get().findServer(this.getServerName());
        if (server == null) {
            return null;
        }
        GitLabSCMNavigatorContext navigatorContext = (GitLabSCMNavigatorContext)new GitLabSCMNavigatorContext().withTraits(this.traits);
        GitLabSCMSourceContext ctx = (GitLabSCMSourceContext)new GitLabSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(navigatorContext.traits());
        GitLabHookRegistration webhookMode = ctx.webhookRegistration();
        switch (webhookMode) {
            case DISABLE: {
                break;
            }
            case SYSTEM: {
                if (!server.isManageWebHooks() || (credentials = server.getCredentials((AccessControlled)owner)) != null) break;
                LOGGER.log(Level.WARNING, "No System credentials added, cannot create web hook");
                break;
            }
            case ITEM: {
                credentials = this.credentials(owner);
                if (credentials != null) break;
                LOGGER.log(Level.WARNING, "No Item credentials added, cannot create web hook");
                break;
            }
            default: {
                return null;
            }
        }
        return credentials;
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMNavigatorOwner owner, SCMNavigatorEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        this.getGitlabOwner(owner);
        String fullName = this.gitlabOwner.getFullName();
        String webUrl = this.gitlabOwner.getWebUrl();
        String avatarUrl = this.gitlabOwner.getAvatarUrl();
        String description = null;
        if (this.gitlabOwner instanceof GitLabGroup) {
            description = ((GitLabGroup)this.gitlabOwner).getDescription();
        }
        ArrayList<Action> result = new ArrayList<Action>();
        result.add((Action)new ObjectMetadataAction(Util.fixEmpty((String)fullName), description, webUrl));
        if (StringUtils.isNotBlank((String)avatarUrl)) {
            result.add((Action)new GitLabAvatar(avatarUrl));
        }
        result.add(GitLabLink.toGroup(webUrl));
        if (StringUtils.isBlank((String)webUrl)) {
            listener.getLogger().println("Web URL unspecified");
        } else {
            listener.getLogger().printf("%s URL: %s%n", this.gitlabOwner.getWord(), HyperlinkNote.encodeTo((String)webUrl, (String)StringUtils.defaultIfBlank((String)fullName, (String)webUrl)));
        }
        return result;
    }

    public void afterSave(@NonNull SCMNavigatorOwner owner) {
        GitLabSCMNavigatorContext navigatorContext = (GitLabSCMNavigatorContext)new GitLabSCMNavigatorContext().withTraits(this.traits);
        GitLabSCMSourceContext ctx = (GitLabSCMSourceContext)new GitLabSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(navigatorContext.traits());
        GitLabHookRegistration systemhookMode = ctx.systemhookRegistration();
        GitLabHookCreator.register(owner, this, systemhookMode);
    }

    public StandardCredentials credentials(SCMSourceOwner owner) {
        return (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)owner, (Authentication)Jenkins.getAuthentication(), (List)URIRequirementBuilder.fromUri((String)GitLabHelper.getServerUrlFromName(this.serverName)).build()), (CredentialsMatcher)new GitLabCredentialMatcher());
    }

    @Symbol(value={"gitlab"})
    @Extension
    public static class DescriptorImpl
    extends SCMNavigatorDescriptor
    implements IconSpec {
        @Inject
        private GitLabSCMSource.DescriptorImpl delegate;

        public static FormValidation doCheckProjectOwner(@AncestorInPath SCMSourceOwner context, @QueryParameter String projectOwner, @QueryParameter String serverName) {
            if (projectOwner.equals("")) {
                return FormValidation.ok();
            }
            GitLabApi gitLabApi = null;
            try {
                gitLabApi = GitLabHelper.apiBuilder((AccessControlled)context, serverName);
                GitLabOwner gitLabOwner = GitLabOwner.fetchOwner(gitLabApi, projectOwner);
                return FormValidation.ok((String)(projectOwner + " is a valid " + gitLabOwner.getWord()));
            }
            catch (IllegalStateException e) {
                return FormValidation.error((Throwable)e, (String)e.getMessage());
            }
        }

        @NonNull
        public String getDisplayName() {
            return "GitLab Group";
        }

        public String getPronoun() {
            return "GitLab Group";
        }

        @NonNull
        public String getDescription() {
            return "Scans a GitLab Group (or GitLab User) for all projects matching some defined markers.";
        }

        public String getIconClassName() {
            return "gitlab-logo";
        }

        public String getIconFilePathPattern() {
            return GitLabIcons.iconFilePathPattern(this.getIconClassName());
        }

        public SCMNavigator newInstance(String name) {
            GitLabSCMNavigator navigator = new GitLabSCMNavigator("");
            navigator.setTraits(this.getTraitsDefaults());
            return navigator;
        }

        public ListBoxModel doFillServerNameItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverName) {
            if (context == null) {
                if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                    ListBoxModel result = new ListBoxModel();
                    result.add(serverName);
                    return result;
                }
            } else if (!context.hasPermission(Item.EXTENDED_READ)) {
                ListBoxModel result = new ListBoxModel();
                result.add(serverName);
                return result;
            }
            return GitLabServers.get().getServerItems();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverName, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (context == null) {
                if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                    result.includeCurrentValue(credentialsId);
                    return result;
                }
            } else if (!context.hasPermission(Item.EXTENDED_READ) && !context.hasPermission(CredentialsProvider.USE_ITEM)) {
                result.includeCurrentValue(credentialsId);
                return result;
            }
            result.includeEmptyValue();
            result.includeMatchingAs(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication() : ACL.SYSTEM, (Item)context, StandardUsernameCredentials.class, URIRequirementBuilder.fromUri((String)GitLabHelper.getServerUrlFromName(serverName)).build(), GitClient.CREDENTIALS_MATCHER);
            return result;
        }

        public List<NamedArrayList<? extends SCMTraitDescriptor<?>>> getTraitsDescriptorLists() {
            GitLabSCMSource.DescriptorImpl sourceDescriptor = (GitLabSCMSource.DescriptorImpl)Jenkins.get().getDescriptorByType(GitLabSCMSource.DescriptorImpl.class);
            ArrayList all = new ArrayList();
            all.addAll(SCMNavigatorTrait._for((SCMNavigatorDescriptor)this, GitLabSCMNavigatorContext.class, GitLabSCMSourceBuilder.class));
            all.addAll(SCMSourceTrait._for((SCMSourceDescriptor)sourceDescriptor, GitLabSCMSourceContext.class, null));
            all.addAll(SCMSourceTrait._for((SCMSourceDescriptor)sourceDescriptor, null, GitLabSCMBuilder.class));
            HashSet<SCMTraitDescriptor> dedup = new HashSet<SCMTraitDescriptor>();
            Iterator iterator = all.iterator();
            while (iterator.hasNext()) {
                SCMTraitDescriptor d = (SCMTraitDescriptor)iterator.next();
                if (dedup.contains(d) || d instanceof GitBrowserSCMSourceTrait.DescriptorImpl) {
                    iterator.remove();
                    continue;
                }
                dedup.add(d);
            }
            ArrayList result = new ArrayList();
            NamedArrayList.select(all, (String)"Projects", (NamedArrayList.Predicate)new NamedArrayList.Predicate<SCMTraitDescriptor<?>>(){

                public boolean test(SCMTraitDescriptor<?> scmTraitDescriptor) {
                    return scmTraitDescriptor instanceof SCMNavigatorTraitDescriptor;
                }
            }, (boolean)true, result);
            NamedArrayList.select(all, (String)"Within project", (NamedArrayList.Predicate)NamedArrayList.anyOf((NamedArrayList.Predicate[])new NamedArrayList.Predicate[]{NamedArrayList.withAnnotation(Discovery.class), NamedArrayList.withAnnotation(Selection.class)}), (boolean)true, result);
            NamedArrayList.select(all, (String)"Additional", null, (boolean)true, result);
            return result;
        }

        @NonNull
        public List<SCMTrait<? extends SCMTrait<?>>> getTraitsDefaults() {
            return new ArrayList<SCMSourceTrait>(this.delegate.getTraitsDefaults());
        }
    }
}

