/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.damnhandy.uri.template.UriTemplate;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.security.ACL;
import io.jenkins.plugins.gitlabbranchsource.BranchSCMRevision;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSource;
import io.jenkins.plugins.gitlabbranchsource.GitLabTagSCMHead;
import io.jenkins.plugins.gitlabbranchsource.MergeRequestSCMHead;
import io.jenkins.plugins.gitlabbranchsource.MergeRequestSCMRevision;
import io.jenkins.plugins.gitlabbranchsource.helpers.GitLabBrowser;
import io.jenkins.plugins.gitlabbranchsource.helpers.GitLabHelper;
import java.net.URI;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.List;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.plugins.git.MergeWithGitSCMExtension;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RefSpec;

public class GitLabSCMBuilder
extends GitSCMBuilder<GitLabSCMBuilder> {
    private static final SecureRandom RANDOM = new SecureRandom();
    @CheckForNull
    private final SCMSourceOwner context;
    @NonNull
    private final String serverUrl;
    @NonNull
    private final String projectPath;
    private final String sshRemote;
    private final String httpRemote;

    public GitLabSCMBuilder(@NonNull GitLabSCMSource source, @NonNull SCMHead head, @CheckForNull SCMRevision revision) {
        super(head, revision, source.getHttpRemote(), source.getCredentialsId());
        String projectUrl;
        this.context = source.getOwner();
        this.serverUrl = StringUtils.defaultIfBlank((String)GitLabHelper.getServerUrlFromName(source.getServerName()), (String)"https://gitlab.com");
        this.projectPath = source.getProjectPath();
        this.sshRemote = source.getSshRemote();
        this.httpRemote = source.getHttpRemote();
        this.withoutRefSpecs();
        if (head instanceof MergeRequestSCMHead) {
            MergeRequestSCMHead h = (MergeRequestSCMHead)head;
            this.withRefSpec("+refs/merge-requests/" + h.getId() + "/head:refs/remotes/@{remote}/" + head.getName());
            projectUrl = this.projectUrl(h.getOriginProjectPath());
        } else if (head instanceof GitLabTagSCMHead) {
            this.withRefSpec("+refs/tags/" + head.getName() + ":refs/tags/" + head.getName());
            projectUrl = this.projectUrl(this.projectPath);
        } else {
            this.withRefSpec("+refs/heads/" + head.getName() + ":refs/remotes/@{remote}/" + head.getName());
            projectUrl = this.projectUrl(this.projectPath);
        }
        this.withBrowser(new GitLabBrowser(projectUrl));
    }

    public static UriTemplate checkoutUriTemplate(@CheckForNull Item context, @NonNull String serverUrl, @CheckForNull String httpRemote, @CheckForNull String sshRemote, @CheckForNull String credentialsId, @NonNull String projectPath) {
        if (credentialsId != null && sshRemote != null) {
            StandardUsernameCredentials credentials;
            URIRequirementBuilder builder = URIRequirementBuilder.create();
            URI serverUri = URI.create(serverUrl);
            if (serverUri.getHost() != null) {
                builder.withHostname(serverUri.getHost());
            }
            if ((credentials = (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)context, (Authentication)(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication() : ACL.SYSTEM), (List)builder.build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId), CredentialsMatchers.instanceOf(StandardUsernameCredentials.class)}))) instanceof SSHUserPrivateKey) {
                return UriTemplate.buildFromTemplate((String)sshRemote).build();
            }
        }
        if (httpRemote != null) {
            return UriTemplate.buildFromTemplate((String)httpRemote).build();
        }
        return UriTemplate.buildFromTemplate((String)(serverUrl + "/" + projectPath)).literal(".git").build();
    }

    private String projectUrl(String projectPath) {
        return GitLabHelper.projectUriTemplate(this.serverUrl).set("project", (Object)GitLabHelper.splitPath(projectPath)).expand();
    }

    @NonNull
    public final UriTemplate checkoutUriTemplate() {
        return GitLabSCMBuilder.checkoutUriTemplate((Item)this.context, this.serverUrl, this.httpRemote, this.sshRemote, this.credentialsId(), this.projectPath);
    }

    @NonNull
    public final GitLabSCMBuilder withGitLabRemote() {
        String projectUrl;
        this.withRemote(this.checkoutUriTemplate().expand());
        SCMHead h = this.head();
        if (h instanceof MergeRequestSCMHead) {
            MergeRequestSCMHead head = (MergeRequestSCMHead)h;
            projectUrl = this.projectUrl(head.getOriginProjectPath());
        } else {
            projectUrl = this.projectUrl(this.projectPath);
        }
        if (projectUrl != null) {
            this.withBrowser(new GitLabBrowser(projectUrl));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public GitSCM build() {
        SCMHead h = this.head();
        SCMRevision r = this.revision();
        try {
            this.withGitLabRemote();
            if (h instanceof MergeRequestSCMHead) {
                MergeRequestSCMHead head = (MergeRequestSCMHead)h;
                if (head.getCheckoutStrategy() == ChangeRequestCheckoutStrategy.MERGE) {
                    String name = head.getTarget().getName();
                    Object localName = "remotes/" + this.remoteName() + "/" + name;
                    HashSet<String> localNames = new HashSet<String>();
                    boolean match = false;
                    String targetSrc = "refs/heads/" + name;
                    String targetDst = "refs/remotes/" + this.remoteName() + "/" + name;
                    for (RefSpec b : this.asRefSpecs()) {
                        String dst = b.getDestination();
                        assert (dst.startsWith("refs/")) : "All git references must start with refs/";
                        if (targetSrc.equals(b.getSource())) {
                            if (targetDst.equals(dst)) {
                                match = true;
                                continue;
                            }
                            localName = dst.substring("refs/".length());
                            match = true;
                            continue;
                        }
                        localNames.add(dst.substring("refs/".length()));
                    }
                    if (!match) {
                        if (localNames.contains(localName)) {
                            localName = "remotes/" + this.remoteName() + "/upstream-" + name;
                        }
                        if (localNames.contains(localName)) {
                            localName = "remotes/" + this.remoteName() + "/merge-requests-" + head.getId() + "-upstream-" + name;
                        }
                        if (localNames.contains(localName)) {
                            while (localNames.contains(localName)) {
                                localName = "remotes/" + this.remoteName() + "/merge-requests-" + head.getId() + "-upstream-" + name + "-" + Integer.toHexString(RANDOM.nextInt(Integer.MAX_VALUE));
                            }
                        }
                        this.withRefSpec("+refs/heads/" + name + ":refs/" + (String)localName);
                    }
                    this.withExtension((GitSCMExtension)new MergeWithGitSCMExtension((String)localName, r instanceof MergeRequestSCMRevision ? ((BranchSCMRevision)((MergeRequestSCMRevision)r).getTarget()).getHash() : null));
                }
                if (r instanceof MergeRequestSCMRevision) {
                    this.withRevision((SCMRevision)((MergeRequestSCMRevision)r).getOrigin());
                }
            }
            GitSCM gitSCM = super.build();
            return gitSCM;
        }
        finally {
            this.withHead(h);
            this.withRevision(r);
        }
    }
}

