/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.gitlabbranchsource.AbstractGitLabSCMHeadEvent;
import io.jenkins.plugins.gitlabbranchsource.BranchSCMHead;
import io.jenkins.plugins.gitlabbranchsource.BranchSCMRevision;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMNavigator;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSource;
import io.jenkins.plugins.gitlabbranchsource.GitLabWebHookCause;
import java.util.Collections;
import java.util.Map;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import org.apache.commons.lang.StringUtils;
import org.gitlab4j.api.webhook.PushEvent;

public class GitLabPushSCMEvent
extends AbstractGitLabSCMHeadEvent<PushEvent> {
    public GitLabPushSCMEvent(PushEvent pushEvent, String origin) {
        super(GitLabPushSCMEvent.typeOf(pushEvent), pushEvent, origin);
    }

    public String descriptionFor(@NonNull SCMNavigator navigator) {
        return this.description();
    }

    @NonNull
    public String getSourceName() {
        return ((PushEvent)this.getPayload()).getProject().getPathWithNamespace();
    }

    public String descriptionFor(SCMSource source) {
        String ref = ((PushEvent)this.getPayload()).getRef();
        ref = ref.startsWith("refs/heads/") ? ref.substring("refs/heads/".length()) : ref;
        return "Push event to branch " + ref;
    }

    public String description() {
        String ref = ((PushEvent)this.getPayload()).getRef();
        ref = ref.startsWith("refs/heads/") ? ref.substring("refs/heads/".length()) : ref;
        return "Push event to branch " + ref + " in project " + ((PushEvent)this.getPayload()).getProject().getPathWithNamespace();
    }

    @Override
    public boolean isMatch(@NonNull GitLabSCMNavigator navigator) {
        return navigator.getNavigatorProjects().contains(((PushEvent)this.getPayload()).getProject().getPathWithNamespace());
    }

    @Override
    public boolean isMatch(@NonNull GitLabSCMSource source) {
        return ((PushEvent)this.getPayload()).getProject().getId().equals(source.getProjectId());
    }

    @Override
    @NonNull
    public Map<SCMHead, SCMRevision> headsFor(GitLabSCMSource source) {
        String ref = ((PushEvent)this.getPayload()).getRef();
        ref = ref.startsWith("refs/heads/") ? ref.substring("refs/heads/".length()) : ref;
        BranchSCMHead h = new BranchSCMHead(ref);
        return Collections.singletonMap(h, StringUtils.isNotBlank((String)((PushEvent)this.getPayload()).getAfter()) ? new BranchSCMRevision(h, ((PushEvent)this.getPayload()).getAfter()) : null);
    }

    @Override
    public GitLabWebHookCause getCause() {
        return new GitLabWebHookCause().fromPush((PushEvent)this.getPayload());
    }
}

