/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMNavigator;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSource;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceEvent;
import org.gitlab4j.api.systemhooks.ProjectSystemHookEvent;

public class GitLabProjectSCMEvent
extends SCMSourceEvent<ProjectSystemHookEvent> {
    public GitLabProjectSCMEvent(ProjectSystemHookEvent projectSystemHookEvent, String origin) {
        super(GitLabProjectSCMEvent.typeOf(projectSystemHookEvent), (Object)projectSystemHookEvent, origin);
    }

    private static SCMEvent.Type typeOf(ProjectSystemHookEvent projectSystemHookEvent) {
        switch (projectSystemHookEvent.getEventName()) {
            case "project_create": {
                return SCMEvent.Type.CREATED;
            }
            case "project_destroy": {
                return SCMEvent.Type.REMOVED;
            }
            case "project_update": {
                return SCMEvent.Type.UPDATED;
            }
        }
        throw new IllegalArgumentException("cannot handle system-hook " + projectSystemHookEvent);
    }

    public String descriptionFor(@NonNull SCMNavigator navigator) {
        return this.description();
    }

    public String description() {
        return "Project event to branch " + ((ProjectSystemHookEvent)this.getPayload()).getPath() + " in namespace " + ((ProjectSystemHookEvent)this.getPayload()).getPathWithNamespace();
    }

    public String descriptionFor(SCMSource source) {
        return "Project event in " + ((ProjectSystemHookEvent)this.getPayload()).getPathWithNamespace();
    }

    @NonNull
    public String getSourceName() {
        return ((ProjectSystemHookEvent)this.getPayload()).getPathWithNamespace();
    }

    public boolean isMatch(@NonNull SCMNavigator navigator) {
        return navigator instanceof GitLabSCMNavigator && this.isMatch((GitLabSCMNavigator)navigator);
    }

    private boolean isMatch(@NonNull GitLabSCMNavigator navigator) {
        switch (this.getType()) {
            case CREATED: {
                String projectPathWithNamespace = ((ProjectSystemHookEvent)this.getPayload()).getPathWithNamespace();
                String projectOwner = GitLabSCMNavigator.getProjectOwnerFromNamespace(projectPathWithNamespace);
                if (navigator.isGroup()) {
                    if (navigator.isWantSubGroupProjects()) {
                        return projectOwner.startsWith(navigator.getProjectOwner());
                    }
                    return projectOwner.equals(navigator.getProjectOwner());
                }
                return projectOwner.equals(navigator.getProjectOwner());
            }
            case UPDATED: {
                return navigator.getNavigatorProjects().contains(((ProjectSystemHookEvent)this.getPayload()).getPathWithNamespace());
            }
            case REMOVED: {
                return navigator.getNavigatorProjects().contains(((ProjectSystemHookEvent)this.getPayload()).getPathWithNamespace());
            }
        }
        return false;
    }

    public boolean isMatch(@NonNull SCMSource source) {
        return source instanceof GitLabSCMSource && ((ProjectSystemHookEvent)this.getPayload()).getProjectId().equals(((GitLabSCMSource)source).getProjectId());
    }
}

