/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.security.ACL;
import hudson.security.ACLContext;
import io.jenkins.plugins.gitlabbranchsource.AbstractGitLabJobTrigger;
import io.jenkins.plugins.gitlabbranchsource.GitLabMergeRequestCommentCause;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSource;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSourceContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.branch.MultiBranchProject;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.SCMSourceOwners;
import org.acegisecurity.Authentication;
import org.gitlab4j.api.models.AccessLevel;
import org.gitlab4j.api.webhook.NoteEvent;

public class GitLabMergeRequestCommentTrigger
extends AbstractGitLabJobTrigger<NoteEvent> {
    public static final Logger LOGGER = Logger.getLogger(GitLabMergeRequestCommentTrigger.class.getName());

    public GitLabMergeRequestCommentTrigger(NoteEvent payload) {
        super(payload);
    }

    @Override
    public void isMatch() {
        if (((NoteEvent)this.getPayload()).getObjectAttributes().getNoteableType().equals((Object)NoteEvent.NoteableType.MERGE_REQUEST)) {
            Long mergeRequestId = ((NoteEvent)this.getPayload()).getMergeRequest().getIid();
            Pattern mergeRequestJobNamePattern = Pattern.compile("^MR-" + mergeRequestId + "\\b.*$", 2);
            String commentBody = ((NoteEvent)this.getPayload()).getObjectAttributes().getNote();
            String commentUrl = ((NoteEvent)this.getPayload()).getObjectAttributes().getUrl();
            try (ACLContext ctx = ACL.as((Authentication)ACL.SYSTEM);){
                boolean jobFound = false;
                for (SCMSourceOwner owner : SCMSourceOwners.all()) {
                    LOGGER.log(Level.FINEST, String.format("Source Owner: %s", owner.getFullDisplayName()));
                    if (owner.getParent() instanceof ComputedFolder) continue;
                    block6: for (SCMSource source : owner.getSCMSources()) {
                        if (!(source instanceof GitLabSCMSource)) continue;
                        GitLabSCMSource gitLabSCMSource = (GitLabSCMSource)source;
                        GitLabSCMSourceContext sourceContext = (GitLabSCMSourceContext)new GitLabSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(gitLabSCMSource.getTraits());
                        if (!sourceContext.mrCommentTriggerEnabled() || gitLabSCMSource.getProjectId() != ((NoteEvent)this.getPayload()).getMergeRequest().getTargetProjectId().longValue() || !this.isTrustedMember(gitLabSCMSource, sourceContext.getOnlyTrustedMembersCanTrigger())) continue;
                        for (Job job : owner.getAllJobs()) {
                            if (!MultiBranchProject.class.isAssignableFrom(job.getParent().getClass())) continue;
                            MultiBranchProject parentJob = (MultiBranchProject)job.getParent();
                            if (parentJob.getSCMSource(gitLabSCMSource.getId()) == gitLabSCMSource && mergeRequestJobNamePattern.matcher(job.getName()).matches()) {
                                String expectedCommentBody = sourceContext.getCommentBody();
                                Pattern pattern = Pattern.compile(expectedCommentBody, 34);
                                if (commentBody == null || pattern.matcher(commentBody).matches()) {
                                    ParameterizedJobMixIn.scheduleBuild2((Job)job, (int)0, (Action[])new Action[]{new CauseAction((Cause)new GitLabMergeRequestCommentCause(commentUrl, (NoteEvent)this.getPayload()))});
                                    LOGGER.log(Level.INFO, "Triggered build for {0} due to MR comment on {1}", new Object[]{job.getFullName(), ((NoteEvent)this.getPayload()).getProject().getPathWithNamespace()});
                                    continue block6;
                                }
                                LOGGER.log(Level.INFO, "MR comment does not match the trigger build string ({0}) for {1}", new Object[]{expectedCommentBody, job.getFullName()});
                                continue block6;
                            }
                            jobFound = true;
                        }
                    }
                }
                if (!jobFound) {
                    LOGGER.log(Level.INFO, "MR comment on {0} did not match any job", new Object[]{((NoteEvent)this.getPayload()).getProject().getPathWithNamespace()});
                }
            }
        }
    }

    private boolean isTrustedMember(GitLabSCMSource gitLabSCMSource, boolean check) {
        if (!check) {
            return true;
        }
        AccessLevel permission = gitLabSCMSource.getMembers().get(((NoteEvent)this.getPayload()).getUser().getUsername());
        if (permission != null) {
            switch (permission) {
                case MAINTAINER: 
                case DEVELOPER: 
                case OWNER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

