/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import hudson.Extension;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSource;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSourceContext;
import io.jenkins.plugins.gitlabbranchsource.Messages;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class GitLabAvatarTrait
extends SCMSourceTrait {
    private boolean disableProjectAvatar = false;

    @DataBoundConstructor
    public GitLabAvatarTrait() {
    }

    @DataBoundSetter
    public void setDisableProjectAvatar(boolean disableProjectAvatar) {
        this.disableProjectAvatar = disableProjectAvatar;
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        if (context instanceof GitLabSCMSourceContext) {
            GitLabSCMSourceContext ctx = (GitLabSCMSourceContext)context;
            ctx.withProjectAvatarDisabled(this.isDisableProjectAvatar());
        }
    }

    public boolean isDisableProjectAvatar() {
        return this.disableProjectAvatar;
    }

    @Extension
    @Symbol(value={"gitlabAvatar"})
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        public String getDisplayName() {
            return Messages.GitLabAvatarTrait_displayName();
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return GitLabSCMSourceContext.class;
        }

        public Class<? extends SCMSource> getSourceClass() {
            return GitLabSCMSource.class;
        }
    }
}

