/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.gitlabbranchsource.BranchSCMHead;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSource;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSourceContext;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSourceRequest;
import io.jenkins.plugins.gitlabbranchsource.Messages;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMHeadAuthority;
import jenkins.scm.api.trait.SCMHeadAuthorityDescriptor;
import jenkins.scm.api.trait.SCMHeadFilter;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceRequest;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.impl.trait.Discovery;
import org.gitlab4j.api.models.MergeRequest;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class BranchDiscoveryTrait
extends SCMSourceTrait {
    private int strategyId;

    @DataBoundConstructor
    public BranchDiscoveryTrait(int strategyId) {
        this.strategyId = strategyId;
    }

    public BranchDiscoveryTrait(boolean buildBranch, boolean buildBranchWithMr) {
        this.strategyId = (buildBranch ? 1 : 0) + (buildBranchWithMr ? 2 : 0);
    }

    public int getStrategyId() {
        return this.strategyId;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isBuildBranch() {
        return (this.strategyId & 1) != 0;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isBuildBranchesWithMR() {
        return (this.strategyId & 2) != 0;
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        GitLabSCMSourceContext ctx = (GitLabSCMSourceContext)context;
        ctx.wantBranches(true);
        ctx.withAuthority(new BranchSCMHeadAuthority());
        switch (this.strategyId) {
            case 1: {
                ctx.wantOriginMRs(true);
                ctx.withFilter(new ExcludeOriginMRBranchesSCMHeadFilter());
                break;
            }
            case 2: {
                ctx.wantOriginMRs(true);
                ctx.withFilter(new OnlyOriginMRBranchesSCMHeadFilter());
                break;
            }
        }
    }

    public boolean includeCategory(@NonNull SCMHeadCategory category) {
        return category.isUncategorized();
    }

    public static class OnlyOriginMRBranchesSCMHeadFilter
    extends SCMHeadFilter {
        public boolean isExcluded(@NonNull SCMSourceRequest request, @NonNull SCMHead head) {
            if (head instanceof BranchSCMHead && request instanceof GitLabSCMSourceRequest) {
                for (MergeRequest m : ((GitLabSCMSourceRequest)request).getMergeRequests()) {
                    if (!m.getSourceProjectId().equals(m.getTargetProjectId()) || m.getSourceBranch().equalsIgnoreCase(head.getName())) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class ExcludeOriginMRBranchesSCMHeadFilter
    extends SCMHeadFilter {
        public boolean isExcluded(@NonNull SCMSourceRequest request, @NonNull SCMHead head) {
            if (head instanceof BranchSCMHead && request instanceof GitLabSCMSourceRequest) {
                for (MergeRequest m : ((GitLabSCMSourceRequest)request).getMergeRequests()) {
                    if (!m.getSourceProjectId().equals(m.getTargetProjectId()) || !m.getSourceBranch().equalsIgnoreCase(head.getName())) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class BranchSCMHeadAuthority
    extends SCMHeadAuthority<SCMSourceRequest, BranchSCMHead, SCMRevision> {
        protected boolean checkTrusted(@NonNull SCMSourceRequest request, @NonNull BranchSCMHead head) {
            return true;
        }

        @Extension
        @Symbol(value={"gitLabBranchHeadAuthority"})
        public static class DescriptorImpl
        extends SCMHeadAuthorityDescriptor {
            public boolean isApplicableToOrigin(@NonNull Class<? extends SCMHeadOrigin> originClass) {
                return SCMHeadOrigin.Default.class.isAssignableFrom(originClass);
            }

            @NonNull
            public String getDisplayName() {
                return Messages.BranchDiscoveryTrait_authorityDisplayName();
            }
        }
    }

    @Symbol(value={"gitLabBranchDiscovery"})
    @Extension
    @Discovery
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.BranchDiscoveryTrait_displayName();
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return GitLabSCMSourceContext.class;
        }

        public Class<? extends SCMSource> getSourceClass() {
            return GitLabSCMSource.class;
        }

        @Restricted(value={NoExternalUse.class})
        @NonNull
        public ListBoxModel doFillStrategyIdItems() {
            ListBoxModel result = new ListBoxModel();
            result.add(Messages.BranchDiscoveryTrait_excludeMRs(), "1");
            result.add(Messages.BranchDiscoveryTrait_onlyMRs(), "2");
            result.add(Messages.BranchDiscoveryTrait_allBranches(), "3");
            return result;
        }
    }
}

