/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gcr.sonar.parsers;

import io.jenkins.plugins.gcr.models.Coverage;
import io.jenkins.plugins.gcr.models.DefaultCoverage;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class SonarCoverageParser {
    private static final String MEASURE_BRANCH = "branch_coverage";
    private static final String MEASURE_LINE = "line_coverage";
    private static final String MEASURE_OVERALL = "coverage";

    public Coverage parse(JSONObject jsonResponse) {
        JSONArray jsonMeasures = jsonResponse.getJSONObject("component").getJSONArray("measures");
        double overallRate = 0.0;
        double lineRate = 0.0;
        double branchRate = 0.0;
        for (Object measure : jsonMeasures.toArray()) {
            JSONObject jsonMeasure = (JSONObject)measure;
            String measureName = jsonMeasure.getString("metric");
            double measureValue = jsonMeasure.getDouble("value");
            if (measureName.equals(MEASURE_OVERALL)) {
                overallRate = measureValue;
            }
            if (measureName.equals(MEASURE_BRANCH)) {
                branchRate = measureValue;
            }
            if (!measureName.equals(MEASURE_LINE)) continue;
            lineRate = measureValue;
        }
        return new DefaultCoverage(overallRate / 100.0, lineRate / 100.0, branchRate / 100.0);
    }
}

