/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gcr.models;

import hudson.EnvVars;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PluginEnvironment {
    private String pullRequestRepository;
    private String gitHash;
    private String pullId;
    private String buildUrl;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PluginEnvironment(EnvVars env) throws IllegalArgumentException {
        if (env.containsKey((Object)"ghprbGhRepository") && env.containsKey((Object)"ghprbActualCommit")) {
            this.pullRequestRepository = this.get("ghprbGhRepository", env);
            this.gitHash = this.get("ghprbActualCommit", env);
        } else if (env.containsKey((Object)"CHANGE_URL")) {
            String changeUrl = this.get("CHANGE_URL", env);
            Pattern pattern = Pattern.compile("https://[^/]*/(.*?)/pull/(.*)");
            Matcher matcher = pattern.matcher(changeUrl);
            if (!matcher.find()) throw new IllegalArgumentException(String.format("Can't find the owner/repo from CHANGE_URL environmental variable '%s'", changeUrl));
            this.pullRequestRepository = matcher.group(1);
            this.pullId = matcher.group(2);
        } else {
            String gitUrl = this.get("GIT_URL", env);
            Pattern pattern = Pattern.compile("[^/]*@[^/]*:(.*?)\\.git");
            Matcher matcher = pattern.matcher(gitUrl);
            if (!matcher.find()) {
                throw new IllegalArgumentException(String.format("Can't find the owner/repo from GIT_URL environmental variable '%s'", gitUrl));
            }
            this.pullRequestRepository = matcher.group(1);
            this.pullId = this.get("CHANGE_ID", env);
        }
        this.buildUrl = this.get("BUILD_URL", env);
    }

    public String getGitHash() {
        return this.gitHash;
    }

    public String getPullId() {
        return this.pullId;
    }

    public String getPullRequestRepository() {
        return this.pullRequestRepository;
    }

    public String getBuildUrl() {
        return this.buildUrl;
    }

    private String get(String key, EnvVars env) throws IllegalArgumentException {
        if (env.containsKey((Object)key)) {
            return (String)env.get((Object)key);
        }
        throw new IllegalArgumentException(String.format("Failed to get required environmental variable '%s'", key));
    }
}

