/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gcr.models;

import io.jenkins.plugins.gcr.models.JacocoCounter;
import io.jenkins.plugins.gcr.models.XmlCoverage;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="report")
public class JacocoCoverage
extends XmlCoverage {
    public static final String TYPE_INSTRUCTION = "INSTRUCTION";
    public static final String TYPE_BRANCH = "BRANCH";
    public static final String TYPE_LINE = "LINE";
    public static final String TYPE_COMPLEXITY = "COMPLEXITY";
    @XmlElement(name="counter")
    public List<JacocoCounter> counters;

    @Override
    public double getLineRate() {
        JacocoCounter counter = this.filterStreamFor(TYPE_LINE).findAny().get();
        return this.rateForCounter(counter);
    }

    @Override
    public double getBranchRate() {
        JacocoCounter counter = this.filterStreamFor(TYPE_BRANCH).findAny().get();
        return this.rateForCounter(counter);
    }

    private Stream<JacocoCounter> filterStreamFor(String type) {
        return this.counters.stream().filter(obj -> obj.type.equals(type));
    }

    private double rateForCounter(JacocoCounter counter) {
        return (double)counter.covered / (double)counter.getTotal();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[ ");
        builder.append(String.format("lineRate=%f, branchRate=%f", this.getLineRate(), this.getBranchRate()));
        builder.append(" ]");
        return builder.toString();
    }
}

