/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gcr;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.gcr.CoverageReportAction;
import io.jenkins.plugins.gcr.Messages;
import io.jenkins.plugins.gcr.PluginConfiguration;
import io.jenkins.plugins.gcr.build.BuildStepService;
import io.jenkins.plugins.gcr.github.GithubClient;
import io.jenkins.plugins.gcr.github.GithubPayload;
import io.jenkins.plugins.gcr.models.ComparisonOption;
import io.jenkins.plugins.gcr.models.CoverageRateType;
import io.jenkins.plugins.gcr.models.CoverageType;
import io.jenkins.plugins.gcr.models.PluginEnvironment;
import io.jenkins.plugins.gcr.sonar.SonarClient;
import io.jenkins.plugins.gcr.sonar.models.SonarProject;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class GithubCoveragePublisher
extends Recorder {
    public static final int COMPARISON_SONAR = 0;
    public static final int COMPARISON_FIXED = 1;
    private final String filepath;
    private String coverageXmlType;
    private String coverageRateType;
    private ComparisonOption comparisonOption;

    @DataBoundConstructor
    public GithubCoveragePublisher(String filepath, String coverageXmlType, String coverageRateType, ComparisonOption comparisonOption) throws IOException {
        this.filepath = filepath;
        this.coverageXmlType = coverageXmlType;
        this.coverageRateType = coverageRateType;
        this.comparisonOption = comparisonOption;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getFilepath() {
        return this.filepath;
    }

    public String getCoverageXmlType() {
        return this.coverageXmlType;
    }

    @DataBoundSetter
    public void setCoverageXmlType(String coverageXmlType) {
        this.coverageXmlType = coverageXmlType;
    }

    public ComparisonOption getComparisonOption() {
        return this.comparisonOption;
    }

    @DataBoundSetter
    public void setComparisonOption(ComparisonOption comparisonOption) {
        this.comparisonOption = comparisonOption;
    }

    public String getSonarProject() {
        return this.comparisonOption.getSonarProject();
    }

    public String getCoverageRateType() {
        return this.coverageRateType;
    }

    @DataBoundSetter
    public void setCoverageRateType(String coverageRateType) {
        this.coverageRateType = coverageRateType;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build == null) {
            return false;
        }
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            return false;
        }
        MutableBoolean codeCoverageAchieved = new MutableBoolean();
        return GithubCoveragePublisher.publishCoverage(build, workspace, (TaskListener)listener, build.getEnvironment((TaskListener)listener), this.filepath, this.coverageXmlType, this.comparisonOption, this.coverageRateType, codeCoverageAchieved);
    }

    public static boolean publishCoverage(Run<?, ?> build, FilePath workspace, TaskListener listener, EnvVars env, String filepath, String coverageXmlType, ComparisonOption comparisonOption, String coverageRateType, MutableBoolean codeCoverageAchieved) throws InterruptedException, IOException {
        codeCoverageAchieved.setValue(false);
        listener.getLogger().println("build: Attempting to parse file of type, " + coverageXmlType + "");
        PluginEnvironment environment = new PluginEnvironment(env);
        String githubAccessToken = PluginConfiguration.DESCRIPTOR.getGithubAccessToken();
        String githubUrl = PluginConfiguration.DESCRIPTOR.getGithubEnterpriseUrl();
        GithubClient githubClient = new GithubClient(environment, githubUrl, githubAccessToken);
        FilePath pathToFile = workspace.child(filepath);
        if (!pathToFile.exists()) {
            listener.error("The coverage file at the provided path does not exist");
            build.setResult(Result.FAILURE);
            return false;
        }
        listener.getLogger().println(String.format("Found file '%s'", filepath));
        BuildStepService buildStepService = new BuildStepService();
        try {
            CoverageReportAction coverageReport = buildStepService.generateCoverageReport(pathToFile, comparisonOption, coverageXmlType, coverageRateType);
            codeCoverageAchieved.setValue(coverageReport.isAcceptableCoverage());
            build.addAction((Action)coverageReport);
            build.save();
            GithubPayload payload = buildStepService.generateGithubCovergePayload(coverageReport, environment.getBuildUrl());
            githubClient.sendCommitStatus(payload);
            build.setResult(Result.SUCCESS);
        }
        catch (Exception ex) {
            listener.error(ex.getMessage());
            ex.printStackTrace();
            build.setResult(Result.FAILURE);
            return false;
        }
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private ListBoxModel sonarProjectModel;

        public ListBoxModel doFillCoverageXmlTypeItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("Cobertura XML", CoverageType.COBERTURA.getIdentifier());
            model.add("Jacoco XML", CoverageType.JACOCO.getIdentifier());
            return model;
        }

        public ListBoxModel doFillSonarProjectItems() {
            this.sonarProjectModel = new ListBoxModel();
            SonarClient client = new SonarClient();
            try {
                List<SonarProject> projects = client.listProjects();
                projects.forEach(project -> this.sonarProjectModel.add(project.getName(), project.getKey()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.sonarProjectModel;
        }

        public ListBoxModel doFillCoverageRateTypeItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("Overall", CoverageRateType.OVERALL.getName());
            model.add("Branch", CoverageRateType.BRANCH.getName());
            model.add("Line", CoverageRateType.LINE.getName());
            return model;
        }

        public FormValidation doCheckSonarProject(@QueryParameter String value) {
            if (this.sonarProjectModel == null || this.sonarProjectModel.isEmpty()) {
                return FormValidation.error((String)"SonarQube server unreachable.");
            }
            if (value == null || value.equals("")) {
                return FormValidation.error((String)"Invalid project selection. check that your SonarQube server is not unreachable.");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.GithubCoveragePublisher_DescriptorImpl_DisplayName();
        }
    }
}

