/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.reference;

import edu.hm.hafner.util.FilteredLog;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Run;
import io.jenkins.plugins.forensics.git.reference.BuildCommits;
import io.jenkins.plugins.forensics.git.reference.Messages;
import io.jenkins.plugins.forensics.git.util.GitCommitTextDecorator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import jenkins.model.RunAction2;
import org.eclipse.jgit.lib.ObjectId;

@SuppressFBWarnings(value={"SE"}, justification="transient field owner is restored using a Jenkins callback")
public class GitCommitsRecord
implements RunAction2,
Serializable {
    private static final long serialVersionUID = 8994811233847179343L;
    private transient Run<?, ?> owner;
    private final String scmKey;
    private final String latestCommit;
    private final RecordingType recordingType;
    private final String latestCommitLink;
    private final String targetParentCommit;
    private final List<String> commits;
    private final List<String> errorMessages;
    private final List<String> infoMessages;

    public static Optional<GitCommitsRecord> findRecordForScm(Run<?, ?> build, String scmKey) {
        return build.getActions(GitCommitsRecord.class).stream().filter(record -> record.getScmKey().contains(scmKey)).findAny();
    }

    public GitCommitsRecord(Run<?, ?> owner, String scmKey, FilteredLog logger, BuildCommits commits, String latestCommitLink) {
        this.owner = owner;
        this.scmKey = scmKey;
        this.infoMessages = new ArrayList<String>(logger.getInfoMessages());
        this.errorMessages = new ArrayList<String>(logger.getErrorMessages());
        this.latestCommit = commits.getMergeOrLatestCommit();
        this.latestCommitLink = latestCommitLink;
        this.commits = new ArrayList<String>(commits.getCommits());
        this.recordingType = commits.getRecordingType();
        this.targetParentCommit = commits.getTarget().name();
    }

    public Run<?, ?> getOwner() {
        return this.owner;
    }

    public boolean isFirstBuild() {
        return this.recordingType == RecordingType.START;
    }

    public String getScmKey() {
        return this.scmKey;
    }

    public String getLatestCommit() {
        return this.latestCommit;
    }

    public String getLatestCommitLink() {
        return this.latestCommitLink;
    }

    public String getTargetParentCommit() {
        return this.targetParentCommit;
    }

    public boolean hasTargetParentCommit() {
        return !ObjectId.zeroId().name().equals(this.targetParentCommit);
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public List<String> getInfoMessages() {
        return this.infoMessages;
    }

    public int size() {
        return this.commits.size();
    }

    public int getSize() {
        return this.size();
    }

    public boolean isNotEmpty() {
        return !this.commits.isEmpty();
    }

    public boolean isEmpty() {
        return this.commits.isEmpty();
    }

    public List<String> getCommits() {
        return this.commits;
    }

    public List<String> getCommitsWithMerge() {
        ArrayList<String> foundCommits = new ArrayList<String>(this.getCommits());
        if (foundCommits.contains(this.latestCommit) || ObjectId.zeroId().name().equals(this.targetParentCommit)) {
            return foundCommits;
        }
        foundCommits.add(0, this.latestCommit);
        foundCommits.add(1, this.targetParentCommit);
        return foundCommits;
    }

    public boolean contains(String commit) {
        return this.commits.contains(commit);
    }

    public void onAttached(Run<?, ?> run) {
        this.owner = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.onAttached(run);
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return Messages.Action_DisplayName();
    }

    public String getUrlName() {
        return null;
    }

    public String toString() {
        return String.format("Commits in '%s': %d (latest: %s)", this.owner, this.size(), this.getLatestCommit());
    }

    public Optional<Run<?, ?>> getReferencePoint(GitCommitsRecord referenceCommits, int maxCommits, boolean skipUnknownCommits) {
        return this.getReferencePoint(referenceCommits, maxCommits, skipUnknownCommits, new FilteredLog("UNUSED"));
    }

    Optional<Run<?, ?>> getReferencePoint(GitCommitsRecord referenceCommits, int maxCommits, boolean skipUnknownCommits, FilteredLog logger) {
        Run build;
        GitCommitTextDecorator textDecorator = new GitCommitTextDecorator();
        List<String> branchCommits = this.collectBranchCommits(maxCommits);
        logger.logInfo("-> detected %d commits in current branch (last one: '%s')", new Object[]{branchCommits.size(), this.getHeadCommitOf(branchCommits, textDecorator)});
        ArrayList<String> targetCommits = new ArrayList<String>();
        for (build = referenceCommits.owner; targetCommits.size() < maxCommits && build != null; build = build.getPreviousBuild()) {
            if (this.owner.getExternalizableId().equals(build.getExternalizableId())) continue;
            List<String> additionalCommits = this.getCommitsForRepository(build);
            logger.logInfo("-> adding %d commits from build '%s' of reference job (last one: '%s')", new Object[]{additionalCommits.size(), build.getDisplayName(), this.getHeadCommitOf(additionalCommits, textDecorator)});
            if (!skipUnknownCommits || branchCommits.containsAll(additionalCommits)) {
                targetCommits.addAll(additionalCommits);
                Optional<String> referencePoint = branchCommits.stream().filter(targetCommits::contains).findFirst();
                if (referencePoint.isPresent()) {
                    logger.logInfo("-> found a matching commit in current branch and target branch: '%s'", new Object[]{textDecorator.asText(referencePoint.get())});
                    return Optional.of(build);
                }
                logger.logInfo("-> no matching commit found yet, continuing with commits of previous build of '%s'", new Object[]{build.getDisplayName()});
                continue;
            }
            logger.logInfo("-> not all commits of target branch are part of the collected reference builds yet", new Object[0]);
        }
        if (build == null) {
            logger.logInfo("-> stopping commit search since we reached the first build of the reference job", new Object[0]);
        }
        if (targetCommits.size() >= maxCommits) {
            logger.logInfo("-> stopping commit search since the #commits of the target builds is %d and the limit `maxCommits` has been set to %d", new Object[]{targetCommits.size(), maxCommits});
        }
        return Optional.empty();
    }

    private String getHeadCommitOf(List<String> additionalCommits, GitCommitTextDecorator textDecorator) {
        return additionalCommits.isEmpty() ? "-" : textDecorator.asText(additionalCommits.get(0));
    }

    private List<String> collectBranchCommits(int maxCommits) {
        ArrayList<String> branchCommits = new ArrayList<String>();
        for (Run build = this.owner; branchCommits.size() < maxCommits && build != null; build = build.getPreviousBuild()) {
            branchCommits.addAll(this.getCommitsForRepository(build));
        }
        return branchCommits;
    }

    private List<String> getCommitsForRepository(Run<?, ?> run) {
        return GitCommitsRecord.findRecordForScm(run, this.getScmKey()).map(GitCommitsRecord::getCommitsWithMerge).orElse(Collections.emptyList());
    }

    static enum RecordingType {
        START,
        INCREMENTAL;

    }
}

