/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.miner;

import hudson.remoting.VirtualChannel;
import io.jenkins.plugins.forensics.git.miner.CommitAnalyzer;
import io.jenkins.plugins.forensics.git.util.AbstractRepositoryCallback;
import io.jenkins.plugins.forensics.git.util.RemoteResultWrapper;
import io.jenkins.plugins.forensics.miner.CommitDiffItem;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;

class RepositoryStatisticsCallback
extends AbstractRepositoryCallback<RemoteResultWrapper<ArrayList<CommitDiffItem>>> {
    private static final long serialVersionUID = 7667073858514128136L;
    private final String previousCommitId;

    RepositoryStatisticsCallback(String previousCommitId) {
        this.previousCommitId = previousCommitId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteResultWrapper<ArrayList<CommitDiffItem>> invoke(Repository repository, VirtualChannel channel) {
        ArrayList<CommitDiffItem> commits = new ArrayList<CommitDiffItem>();
        RemoteResultWrapper<ArrayList<CommitDiffItem>> wrapper = new RemoteResultWrapper<ArrayList<CommitDiffItem>>(commits, "Errors while mining the Git repository:");
        try {
            try (Git git = new Git(repository);){
                CommitAnalyzer commitAnalyzer = new CommitAnalyzer();
                commits.addAll(commitAnalyzer.run(repository, git, this.previousCommitId, wrapper));
            }
            catch (IOException | GitAPIException exception) {
                wrapper.logException((Exception)exception, "Can't analyze commits for the repository " + repository.getIdentifier(), new Object[0]);
            }
        }
        finally {
            repository.close();
        }
        return wrapper;
    }
}

