/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.miner;

import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.TreeStringBuilder;
import io.jenkins.plugins.forensics.git.miner.CommitCollector;
import io.jenkins.plugins.forensics.git.miner.DiffsCollector;
import io.jenkins.plugins.forensics.miner.CommitDiffItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;

class CommitAnalyzer {
    CommitAnalyzer() {
    }

    List<CommitDiffItem> run(Repository repository, Git git, String latestCommitOfPreviousBuild, FilteredLog logger) throws IOException, GitAPIException {
        List<RevCommit> newRevCommits = new CommitCollector().findAllCommits(repository, git, latestCommitOfPreviousBuild, logger);
        if (newRevCommits.isEmpty()) {
            logger.logInfo("No commits found since previous commit '%s'", new Object[]{latestCommitOfPreviousBuild});
        }
        logger.logInfo("Found %d commits", new Object[]{newRevCommits.size()});
        TreeStringBuilder fileNameBuilder = new TreeStringBuilder();
        ArrayList<CommitDiffItem> commitsOfBuild = new ArrayList<CommitDiffItem>();
        for (int i = 0; i < newRevCommits.size(); ++i) {
            AbstractTreeIterator toTree = this.createTreeIteratorToCompareTo(repository, newRevCommits, i, latestCommitOfPreviousBuild, logger);
            CommitDiffItem commit = this.createFromRevCommit(newRevCommits.get(i));
            commitsOfBuild.addAll(new DiffsCollector().getDiffsForCommit(repository, git, commit, toTree, fileNameBuilder, logger));
        }
        fileNameBuilder.dedup();
        return commitsOfBuild;
    }

    private CommitDiffItem createFromRevCommit(RevCommit newCommit) {
        return new CommitDiffItem(newCommit.getName(), this.getAuthor(newCommit), newCommit.getCommitTime());
    }

    private String getAuthor(RevCommit commit) {
        PersonIdent author = commit.getAuthorIdent();
        if (author != null) {
            return StringUtils.defaultString((String)author.getEmailAddress(), (String)author.getName());
        }
        PersonIdent committer = commit.getCommitterIdent();
        if (committer != null) {
            return StringUtils.defaultString((String)committer.getEmailAddress(), (String)committer.getName());
        }
        return "";
    }

    private AbstractTreeIterator createTreeIteratorToCompareTo(Repository repository, List<RevCommit> newCommits, int index, String latestCommitOfPreviousBuild, FilteredLog logger) throws IOException {
        int compareIndex = index + 1;
        if (compareIndex < newCommits.size()) {
            return CommitAnalyzer.createTreeIteratorFor(newCommits.get(compareIndex).getName(), repository, logger);
        }
        if (StringUtils.isNotBlank((CharSequence)latestCommitOfPreviousBuild)) {
            return CommitAnalyzer.createTreeIteratorFor(latestCommitOfPreviousBuild, repository, logger);
        }
        return new EmptyTreeIterator();
    }

    static AbstractTreeIterator createTreeIteratorFor(String commitId, Repository repository, FilteredLog logger) throws IOException {
        try (RevWalk walk = new RevWalk(repository);){
            ObjectId resolve = repository.resolve(commitId);
            if (resolve == null) {
                logger.logError("No commit found with ID " + commitId, new Object[0]);
                EmptyTreeIterator emptyTreeIterator = new EmptyTreeIterator();
                return emptyTreeIterator;
            }
            RevCommit commit = walk.parseCommit((AnyObjectId)resolve);
            RevTree tree = walk.parseTree((AnyObjectId)commit.getTree().getId());
            CanonicalTreeParser treeParser = new CanonicalTreeParser();
            try (ObjectReader reader = repository.newObjectReader();){
                treeParser.reset(reader, (AnyObjectId)tree.getId());
            }
            walk.dispose();
            CanonicalTreeParser canonicalTreeParser = treeParser;
            return canonicalTreeParser;
        }
    }
}

