/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.reference;

import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.VisibleForTesting;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Run;
import io.jenkins.plugins.forensics.reference.ReferenceBuild;
import io.jenkins.plugins.forensics.reference.SimpleReferenceRecorder;
import io.jenkins.plugins.util.JenkinsFacade;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import jenkins.branch.MultiBranchProject;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.metadata.PrimaryInstanceMetadataAction;
import jenkins.scm.api.mixin.ChangeRequestSCMHead;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class ReferenceRecorder
extends SimpleReferenceRecorder {
    private static final String DEFAULT_TARGET_BRANCH = "master";
    private String defaultBranch = "";
    private boolean latestBuildIfNotFound = false;
    private String scm = "";

    protected ReferenceRecorder(JenkinsFacade jenkins) {
        super(jenkins);
    }

    @DataBoundSetter
    public void setLatestBuildIfNotFound(boolean latestBuildIfNotFound) {
        this.latestBuildIfNotFound = latestBuildIfNotFound;
    }

    public boolean isLatestBuildIfNotFound() {
        return this.latestBuildIfNotFound;
    }

    @Deprecated
    @DataBoundSetter
    public void setDefaultBranch(String defaultBranch) {
        this.defaultBranch = StringUtils.stripToEmpty((String)defaultBranch);
    }

    @Deprecated
    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    @DataBoundSetter
    public void setTargetBranch(String targetBranch) {
        this.defaultBranch = StringUtils.stripToEmpty((String)targetBranch);
    }

    public String getTargetBranch() {
        return this.defaultBranch;
    }

    @DataBoundSetter
    public void setScm(String scm) {
        this.scm = scm;
    }

    public String getScm() {
        return this.scm;
    }

    @VisibleForTesting
    ScmFacade getScmFacade() {
        return new ScmFacade();
    }

    @Override
    protected ReferenceBuild findReferenceBuild(Run<?, ?> run, FilteredLog logger) {
        Optional<Job<?, ?>> actualReferenceJob = this.findReferenceJob(run, logger);
        if (actualReferenceJob.isPresent()) {
            Job<?, ?> reference = actualReferenceJob.get();
            Run lastCompletedBuild = reference.getLastCompletedBuild();
            if (lastCompletedBuild == null) {
                logger.logInfo("No completed build found");
            } else {
                Optional<Run<?, ?>> referenceBuild = this.find(run, lastCompletedBuild, logger);
                if (referenceBuild.isPresent()) {
                    Run<?, ?> result = referenceBuild.get();
                    logger.logInfo("Found reference build '%s' for target branch", new Object[]{result.getDisplayName()});
                    return new ReferenceBuild(run, (List<String>)logger.getInfoMessages(), result);
                }
                logger.logInfo("No reference build found that contains matching commits");
                if (this.isLatestBuildIfNotFound()) {
                    logger.logInfo("Falling back to latest build of reference job: '%s'", new Object[]{lastCompletedBuild.getDisplayName()});
                    return new ReferenceBuild(run, (List<String>)logger.getInfoMessages(), lastCompletedBuild);
                }
            }
        }
        return new ReferenceBuild(run, logger.getInfoMessages());
    }

    private Optional<Job<?, ?>> findReferenceJob(Run<?, ?> run, FilteredLog log) {
        Optional<Job<?, ?>> referenceJob = this.resolveReferenceJob(log);
        if (referenceJob.isPresent()) {
            return referenceJob;
        }
        return this.discoverJobFromMultiBranchPipeline(run, log);
    }

    private Optional<Job<?, ?>> discoverJobFromMultiBranchPipeline(Run<?, ?> run, FilteredLog logger) {
        Job job = run.getParent();
        ItemGroup topLevel = job.getParent();
        if (topLevel instanceof MultiBranchProject) {
            MultiBranchProject multiBranchProject = (MultiBranchProject)topLevel;
            logger.logInfo("Found a `MultiBranchProject`, trying to resolve the target branch from the configuration");
            String targetBranch = this.getTargetBranch();
            if (StringUtils.isNotEmpty((CharSequence)targetBranch)) {
                logger.logInfo("-> using target branch '%s' as configured in step", new Object[]{targetBranch});
                return this.findJobForTargetBranch(multiBranchProject, job, targetBranch, logger);
            }
            logger.logInfo("-> no target branch configured in step", new Object[]{targetBranch});
            Optional<SCMHead> possibleHead = this.findTargetBranchHead(job);
            if (possibleHead.isPresent()) {
                SCMHead target = possibleHead.get();
                logger.logInfo("-> detected a pull or merge request for target branch '%s'", new Object[]{target.getName()});
                return this.findJobForTargetBranch(multiBranchProject, job, target.getName(), logger);
            }
            Optional<? extends Job> possiblePrimaryBranch = this.findPrimaryBranch(topLevel);
            if (possiblePrimaryBranch.isPresent()) {
                Job primaryBranchJob = possiblePrimaryBranch.get();
                logger.logInfo("-> using configured primary branch '%s' of SCM as target branch", new Object[]{primaryBranchJob.getDisplayName()});
                return Optional.of(primaryBranchJob);
            }
            logger.logInfo("-> falling back to plugin default target branch '%s'", new Object[]{DEFAULT_TARGET_BRANCH});
            return this.findJobForTargetBranch(multiBranchProject, job, DEFAULT_TARGET_BRANCH, logger);
        }
        logger.logInfo("Consider configuring a reference job using the 'referenceJob' property");
        return Optional.empty();
    }

    protected Optional<SCMHead> findTargetBranchHead(Job<?, ?> job) {
        return this.getScmFacade().findHead(job).map(ChangeRequestSCMHead::getTarget);
    }

    private Optional<? extends Job> findPrimaryBranch(ItemGroup<?> topLevel) {
        return topLevel.getAllItems().stream().map(Item::getAllJobs).flatMap(Collection::stream).filter(this::hasDefaultTargetBranchDefined).findAny();
    }

    private boolean hasDefaultTargetBranchDefined(Job<?, ?> job) {
        return job.getAction(PrimaryInstanceMetadataAction.class) != null;
    }

    private Optional<Job<?, ?>> findJobForTargetBranch(MultiBranchProject<?, ?> multiBranchProject, Job<?, ?> job, String targetBranch, FilteredLog logger) {
        Job target = multiBranchProject.getItemByBranchName(targetBranch);
        if (job.equals((Object)target)) {
            logger.logInfo("-> no reference job required - this build is already for the default target branch '%s'", new Object[]{job.getName()});
        } else if (target != null) {
            logger.logInfo("-> inferred job for target branch: '%s'", new Object[]{target.getDisplayName()});
            return Optional.of(target);
        }
        logger.logError("-> no job found for target branch '%s' (is the branch correctly defined?)", new Object[]{targetBranch});
        return Optional.empty();
    }

    protected Optional<Run<?, ?>> find(Run<?, ?> owner, Run<?, ?> lastCompletedBuildOfReferenceJob, FilteredLog logger) {
        return Optional.empty();
    }

    static class ScmFacade {
        ScmFacade() {
        }

        Optional<ChangeRequestSCMHead> findHead(Job<?, ?> job) {
            SCMHead head = SCMHead.HeadByItem.findHead(job);
            if (head instanceof ChangeRequestSCMHead) {
                return Optional.of((ChangeRequestSCMHead)head);
            }
            return Optional.empty();
        }
    }
}

