/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.reference;

import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Run;
import io.jenkins.plugins.bootstrap5.MessagesViewModel;
import io.jenkins.plugins.forensics.reference.Messages;
import io.jenkins.plugins.util.JenkinsFacade;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import jenkins.model.RunAction2;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.StaplerProxy;

public class ReferenceBuild
implements RunAction2,
Serializable,
StaplerProxy {
    private static final long serialVersionUID = -4549516129641755356L;
    public static final String NO_REFERENCE_BUILD = "-";
    static final String REFERENCE_DETAILS_URL = "reference";
    private final String referenceBuildId;
    private final JenkinsFacade jenkinsFacade;
    private final List<String> messages;
    @SuppressFBWarnings(value={"SE"}, justification="transient field owner ist restored using a Jenkins callback")
    private transient Run<?, ?> owner;

    public static String getReferenceBuildLink(String referenceBuildId) {
        if (!ReferenceBuild.isValidBuildId(referenceBuildId)) {
            return NO_REFERENCE_BUILD;
        }
        JenkinsFacade jenkinsFacade = new JenkinsFacade();
        Optional possibleReferenceBuild = jenkinsFacade.getBuild(referenceBuildId);
        if (possibleReferenceBuild.isPresent()) {
            return ReferenceBuild.createLink((Run)possibleReferenceBuild.get(), jenkinsFacade);
        }
        return String.format("#%s", referenceBuildId);
    }

    public ReferenceBuild(Run<?, ?> owner, List<String> messages) {
        this(owner, messages, NO_REFERENCE_BUILD);
    }

    public ReferenceBuild(Run<?, ?> owner, List<String> messages, Run<?, ?> referenceBuild) {
        this(owner, messages, referenceBuild.getExternalizableId());
    }

    private ReferenceBuild(Run<?, ?> owner, List<String> messages, String referenceBuildId) {
        this(owner, messages, referenceBuildId, new JenkinsFacade());
    }

    @VisibleForTesting
    ReferenceBuild(Run<?, ?> owner, List<String> messages, String referenceBuildId, JenkinsFacade jenkinsFacade) {
        this.owner = owner;
        this.messages = new ArrayList<String>(messages);
        this.referenceBuildId = referenceBuildId;
        this.jenkinsFacade = jenkinsFacade;
    }

    public void onAttached(Run<?, ?> run) {
        this.owner = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.onAttached(run);
    }

    public Run<?, ?> getOwner() {
        return this.owner;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public String getReferenceLink() {
        return this.getReferenceBuild().map(run -> ReferenceBuild.createLink(run, this.jenkinsFacade)).orElse(String.format("Reference build '%s' not found anymore - maybe the build has been renamed or deleted?", this.getReferenceBuildId()));
    }

    private static String createLink(Run<?, ?> run, JenkinsFacade jenkinsFacade) {
        return ((ContainerTag)((ContainerTag)TagCreator.a().withText(run.getFullDisplayName()).withHref(jenkinsFacade.getAbsoluteUrl(new String[]{run.getUrl()}))).withClasses(new String[]{"model-link", "inside"})).render();
    }

    public boolean hasReferenceBuild() {
        return ReferenceBuild.isValidBuildId(this.referenceBuildId);
    }

    private static boolean isValidBuildId(String buildId) {
        return !StringUtils.equals((CharSequence)buildId, (CharSequence)NO_REFERENCE_BUILD);
    }

    public String getReferenceBuildId() {
        return this.referenceBuildId;
    }

    public Optional<Run<?, ?>> getReferenceBuild() {
        if (this.hasReferenceBuild()) {
            return this.jenkinsFacade.getBuild(this.referenceBuildId);
        }
        return Optional.empty();
    }

    public String getDisplayName() {
        return null;
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return REFERENCE_DETAILS_URL;
    }

    public Object getTarget() {
        return new MessagesViewModel(this.getOwner(), Messages.Messages_DisplayName(), this.messages);
    }
}

