/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.miner;

import edu.hm.hafner.echarts.Palette;
import edu.hm.hafner.echarts.PieChartModel;
import edu.hm.hafner.echarts.PieData;
import io.jenkins.plugins.forensics.miner.FileStatistics;
import io.jenkins.plugins.forensics.miner.RepositoryStatistics;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;

class SizePieChart {
    SizePieChart() {
    }

    public PieChartModel create(RepositoryStatistics repositoryStatistics, Function<FileStatistics, Integer> sizeMethod, int ... breakpoints) {
        PieChartModel model = new PieChartModel();
        TreeMap<Integer, Integer> distribution = new TreeMap<Integer, Integer>();
        for (FileStatistics file : repositoryStatistics.getFileStatistics()) {
            distribution.merge(this.determineBreakpoint(sizeMethod.apply(file), breakpoints), 1, Integer::sum);
        }
        int color = 0;
        for (Map.Entry entry : distribution.entrySet()) {
            model.add(new PieData("< " + entry.getKey(), ((Integer)entry.getValue()).intValue()), Palette.color((int)color++));
        }
        return model;
    }

    private int determineBreakpoint(int size, int ... breakpoints) {
        for (int breakpoint : breakpoints) {
            if (size >= breakpoint) continue;
            return breakpoint;
        }
        return breakpoints.length - 1;
    }
}

