/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.miner;

import edu.hm.hafner.util.FilteredLog;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import io.jenkins.plugins.forensics.miner.ForensicsBuildAction;
import io.jenkins.plugins.forensics.miner.Messages;
import io.jenkins.plugins.forensics.miner.MinerFactory;
import io.jenkins.plugins.forensics.miner.RepositoryMiner;
import io.jenkins.plugins.forensics.miner.RepositoryStatistics;
import io.jenkins.plugins.forensics.util.ScmResolver;
import io.jenkins.plugins.util.BuildAction;
import io.jenkins.plugins.util.LogHandler;
import java.util.List;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class RepositoryMinerStep
extends Recorder
implements SimpleBuildStep {
    private String scm = "";

    @DataBoundConstructor
    public RepositoryMinerStep() {
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Deserialization of instances that do not have all fields yet")
    protected Object readResolve() {
        if (this.scm == null) {
            this.scm = "";
        }
        return this;
    }

    @DataBoundSetter
    public void setScm(String scm) {
        this.scm = scm;
    }

    public String getScm() {
        return this.scm;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException {
        this.mineRepositories(run, workspace, listener);
    }

    private void mineRepositories(Run<?, ?> run, FilePath workspace, TaskListener listener) throws InterruptedException {
        int number = 0;
        for (SCM sCM : new ScmResolver().getScms(run, this.getScm())) {
            long startOfMining = System.nanoTime();
            LogHandler logHandler = new LogHandler(listener, "Forensics");
            FilteredLog logger = new FilteredLog("Errors while mining " + sCM);
            logger.logInfo("Creating SCM miner to obtain statistics for affected repository files");
            logger.logInfo("-> checking SCM '%s'", new Object[]{sCM.getKey()});
            RepositoryMiner miner = MinerFactory.findMiner(sCM, run, workspace, listener, logger);
            logHandler.log(logger);
            RepositoryStatistics repositoryStatistics = this.previousBuildStatistics(this.scm, run);
            RepositoryStatistics addedRepositoryStatistics = miner.mine(repositoryStatistics, logger);
            logHandler.log(logger);
            int miningDurationSeconds = (int)(1L + (System.nanoTime() - startOfMining) / 1000000000L);
            run.addAction((Action)new ForensicsBuildAction(run, addedRepositoryStatistics, miningDurationSeconds, sCM.getKey(), number++));
        }
    }

    private RepositoryStatistics previousBuildStatistics(String repository, Run<?, ?> run) {
        for (Run build = run.getPreviousBuild(); build != null; build = build.getPreviousBuild()) {
            List actions = build.getActions(ForensicsBuildAction.class);
            if (actions.isEmpty()) continue;
            return actions.stream().filter(a -> a.getScmKey().contains(repository)).findAny().map(BuildAction::getResult).orElse(new RepositoryStatistics());
        }
        return new RepositoryStatistics();
    }

    public Descriptor getDescriptor() {
        return (Descriptor)super.getDescriptor();
    }

    @Extension
    @Symbol(value={"mineRepository"})
    public static class Descriptor
    extends BuildStepDescriptor<Publisher> {
        @NonNull
        public String getDisplayName() {
            return Messages.Step_Name();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

