/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.miner;

import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Run;
import io.jenkins.plugins.forensics.miner.CommitStatistics;
import io.jenkins.plugins.forensics.miner.ForensicsJobAction;
import io.jenkins.plugins.forensics.miner.ForensicsViewModel;
import io.jenkins.plugins.forensics.miner.Messages;
import io.jenkins.plugins.forensics.miner.RepositoryStatistics;
import io.jenkins.plugins.forensics.miner.RepositoryStatisticsXmlStream;
import io.jenkins.plugins.util.BuildAction;
import org.kohsuke.stapler.StaplerProxy;

public class ForensicsBuildAction
extends BuildAction<RepositoryStatistics>
implements StaplerProxy {
    private static final long serialVersionUID = -263122257268060032L;
    private static final String DEFAULT_FILE_NAME = "repository-statistics.xml";
    private final int miningDurationSeconds;
    private final String urlName;
    private String scmKey;
    private String fileName;
    private final int numberOfFiles;
    private final int totalLinesOfCode;
    private final int totalChurn;
    private CommitStatistics commitStatistics;

    public ForensicsBuildAction(Run<?, ?> owner, RepositoryStatistics repositoryStatistics, int miningDurationSeconds, String scmKey, int number) {
        this(owner, repositoryStatistics, true, miningDurationSeconds, scmKey, number);
    }

    @VisibleForTesting
    ForensicsBuildAction(Run<?, ?> owner, RepositoryStatistics repositoryStatistics, boolean canSerialize, int miningDurationSeconds, String scmKey, int number) {
        super(owner, (Object)repositoryStatistics, false);
        this.numberOfFiles = repositoryStatistics.size();
        this.miningDurationSeconds = miningDurationSeconds;
        this.scmKey = scmKey;
        this.fileName = this.createFileName(number);
        this.urlName = this.createUrlName(number);
        this.totalLinesOfCode = repositoryStatistics.getTotalLinesOfCode();
        this.totalChurn = repositoryStatistics.getTotalChurn();
        this.commitStatistics = repositoryStatistics.getLatestStatistics();
        if (canSerialize) {
            this.createXmlStream().write(owner.getRootDir().toPath().resolve(this.fileName), repositoryStatistics);
        }
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Deserialization of instances that do not have all fields yet")
    protected Object readResolve() {
        if (this.scmKey == null) {
            this.scmKey = "";
        }
        if (this.fileName == null) {
            this.fileName = DEFAULT_FILE_NAME;
        }
        if (this.commitStatistics == null) {
            this.commitStatistics = new CommitStatistics();
        }
        return super.readResolve();
    }

    private String createFileName(int number) {
        if (number == 0) {
            return DEFAULT_FILE_NAME;
        }
        return String.format("repository-statistics-%d.xml", number);
    }

    private String createUrlName(int number) {
        if (number == 0) {
            return "forensics";
        }
        return String.format("%s-%d", "forensics", number);
    }

    protected ForensicsJobAction createProjectAction() {
        return new ForensicsJobAction(this.getOwner().getParent(), this.scmKey);
    }

    protected final RepositoryStatisticsXmlStream createXmlStream() {
        return new RepositoryStatisticsXmlStream();
    }

    protected String getBuildResultBaseName() {
        return this.fileName;
    }

    public String getIconFileName() {
        return "symbol-solid/microscope plugin-font-awesome-api";
    }

    public String getDisplayName() {
        return Messages.Forensics_Action();
    }

    public Object getTarget() {
        return new ForensicsViewModel(this.getOwner(), (RepositoryStatistics)this.getResult(), this.scmKey);
    }

    public String getUrlName() {
        return this.urlName;
    }

    public int getNumberOfFiles() {
        return this.numberOfFiles;
    }

    public int getMiningDurationSeconds() {
        return this.miningDurationSeconds;
    }

    public int getTotalLinesOfCode() {
        return this.totalLinesOfCode;
    }

    public int getTotalChurn() {
        return this.totalChurn;
    }

    public CommitStatistics getCommitStatistics() {
        return this.commitStatistics;
    }

    public String getScmKey() {
        return this.scmKey;
    }

    public String toString() {
        return String.format("%s [%s]", this.urlName, this.scmKey);
    }
}

