/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.blame;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public class FileLocations
implements Serializable {
    private static final long serialVersionUID = 8063580789984061223L;
    private final Map<String, Set<Integer>> linesPerFile = new HashMap<String, Set<Integer>>();

    public void addLine(String fileName, int lineStart) {
        this.linesPerFile.put(fileName, this.mergeLine(fileName, lineStart));
    }

    private Set<Integer> mergeLine(String fileName, int lineStart) {
        Set<Integer> lines = this.contains(fileName) ? this.linesPerFile.get(fileName) : new HashSet<Integer>();
        lines.add(lineStart);
        return lines;
    }

    public boolean isEmpty() {
        return this.linesPerFile.isEmpty();
    }

    public int size() {
        return this.linesPerFile.keySet().size();
    }

    public boolean contains(String fileName) {
        return this.containsFile(fileName);
    }

    private boolean containsFile(String fileName) {
        return this.linesPerFile.containsKey(fileName);
    }

    public Set<String> getFiles() {
        return Collections.unmodifiableSet(this.linesPerFile.keySet());
    }

    public Set<Integer> getLines(String fileName) {
        if (this.containsFile(fileName)) {
            return Collections.unmodifiableSet(this.linesPerFile.get(fileName));
        }
        throw new NoSuchElementException(String.format("No information for file '%s' stored", fileName));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileLocations that = (FileLocations)o;
        return this.linesPerFile.equals(that.linesPerFile);
    }

    public int hashCode() {
        return Objects.hash(this.linesPerFile);
    }
}

