/*
 * Decompiled with CFR 0.152.
 */
package com.embotics.vlm.rest.v30.client;

import com.embotics.vlm.rest.v30.client.model.Comment;
import com.embotics.vlm.rest.v30.client.model.VCommanderException;
import com.sun.jersey.api.client.ClientResponse;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ClientUtils {
    static final int JSON_NICEFORMAT_SPACING = 2;
    static final String COMMON_ITEMS = "items";
    public static final String REST_FILTER = "filter";

    static void checkResponse(ClientResponse response, int expectedStatusCode) throws VCommanderException {
        if (response.getStatus() != expectedStatusCode) {
            if (response.getStatus() == ClientResponse.Status.UNAUTHORIZED.getStatusCode()) {
                throw new VCommanderException("Access is denied due to invalid credentials.");
            }
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("status_code=").append(response.getStatus()).append(", error_message=").append((String)response.getEntity(String.class));
            throw new VCommanderException(errorMessage.toString());
        }
    }

    static void log(PrintStream logger, String message) {
        if (logger != null) {
            logger.println(message);
        }
    }

    static List<Comment> getComments(ClientResponse commentsResponse) throws JSONException, VCommanderException {
        ClientUtils.checkResponse(commentsResponse, ClientResponse.Status.OK.getStatusCode());
        String commentsStr = (String)commentsResponse.getEntity(String.class);
        JSONObject commentsJSON = new JSONObject(commentsStr);
        JSONArray comments = commentsJSON.getJSONArray(COMMON_ITEMS);
        ArrayList<Comment> commentsList = new ArrayList<Comment>();
        for (int i = comments.length() - 1; i >= 0; --i) {
            JSONObject comment = (JSONObject)comments.get(i);
            commentsList.add(new Comment(comment));
        }
        return commentsList;
    }

    public static String encapsulateInQuots(String in) {
        StringBuilder string = new StringBuilder();
        return string.append("'").append(in.replace("'", "'")).append("'").toString();
    }

    public static String buildFilter(String left, RestFilterOperator operator, String right) {
        StringBuilder filter = new StringBuilder();
        filter.append("(").append(left).append(" ").append("-").append((Object)operator).append(" ").append(right).append(")");
        return filter.toString();
    }

    public static enum RestFilterOperator {
        eq,
        contains,
        ge,
        and;

    }
}

