/*
 * Decompiled with CFR 0.152.
 */
package com.embotics.vlm.plugin.actions;

import com.embotics.vlm.plugin.Messages;
import com.embotics.vlm.plugin.VCommanderAction;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import javax.servlet.ServletException;
import org.kohsuke.stapler.QueryParameter;

public abstract class AbstractVCommanderAction
implements VCommanderAction {
    public static final long DEFAULT_TIMEOUT_VALUE = 10L;
    public static final long MINIMUM_TIMEOUT_VALUE = 1L;
    public static final long DEFAULT_POLLING_VALUE = 15L;
    public static final long MINIMUM_POLLING_VALUE = 10L;
    private final boolean sync;
    private final long timeout;
    private final long polling;

    public AbstractVCommanderAction(boolean sync, Long timeout, Long polling) {
        this.sync = sync;
        this.timeout = AbstractVCommanderAction.getDefault(timeout, 1L, 10L);
        this.polling = AbstractVCommanderAction.getDefault(polling, 10L, 15L);
    }

    public static long getDefault(Long value, long minValue, long defaultValue) {
        return value == null || value < minValue ? defaultValue : value;
    }

    public Boolean getSync() {
        return this.sync;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public Long getPolling() {
        return this.polling;
    }

    public static abstract class AbstractVCommanderActionDescriptor
    extends Descriptor<VCommanderAction> {
        public FormValidation doCheckTimeout(@QueryParameter Long value) throws IOException, ServletException {
            if (value == null || value < 1L) {
                return FormValidation.error((String)Messages.VCommanderBuilder_errors_missingTimeout());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPolling(@QueryParameter Long polling, @QueryParameter Long timeout) throws IOException, ServletException {
            if (polling == null || polling < 10L) {
                return FormValidation.error((String)Messages.VCommanderBuilder_errors_missingPolling());
            }
            if (timeout != null && timeout >= 1L && timeout * 60L < polling) {
                return FormValidation.error((String)Messages.VCommanderBuilder_errors_invalidPolling());
            }
            return FormValidation.ok();
        }
    }
}

