/*
 * Decompiled with CFR 0.152.
 */
package com.embotics.vlm.plugin;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.embotics.vlm.plugin.Messages;
import com.embotics.vlm.rest.v30.client.VCommanderClient;
import com.embotics.vlm.rest.v30.client.model.VCommanderException;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public final class VCommanderConfig
extends GlobalConfiguration {
    private String address;
    private String credentialsId;
    private String orgName;
    private VCommanderClient vCommanderClient;

    public VCommanderConfig() {
        this.load();
    }

    private static VCommanderConfig get() {
        VCommanderConfig config;
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null && (config = (VCommanderConfig)jenkins.getDescriptorByType(VCommanderConfig.class)) != null) {
            return config;
        }
        return null;
    }

    public static VCommanderClient getVCommanderClient() throws VCommanderException {
        VCommanderConfig config = VCommanderConfig.get();
        if (config.vCommanderClient != null) {
            return config.vCommanderClient;
        }
        StandardUsernamePasswordCredentials cred = VCommanderConfig.getCredential(config.getCredentialsId(), config.getAddress());
        if (cred == null) {
            throw new VCommanderException(Messages.VCommanderConfig_connection_failedNoCredential());
        }
        return new VCommanderClient(config.getAddress(), cred.getUsername(), Secret.toString((Secret)cred.getPassword()), config.getOrgName());
    }

    protected void setvCommanderClient(VCommanderClient vCommanderClient) {
        this.vCommanderClient = vCommanderClient;
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        this.save();
        return true;
    }

    private static StandardUsernamePasswordCredentials getCredential(String id, String address) {
        List creds = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)null, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)address).build());
        return (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)creds, (CredentialsMatcher)CredentialsMatchers.withId((String)id));
    }

    private static StandardCredentials getCredentialWithoutDomainAndTypeFiltering(String id) {
        List creds = CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)null, (Authentication)ACL.SYSTEM, Collections.emptyList());
        return (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)creds, (CredentialsMatcher)CredentialsMatchers.withId((String)id));
    }

    public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId, @QueryParameter String address) {
        Jenkins jenkinsInstance;
        StandardListBoxModel result = new StandardListBoxModel();
        StandardCredentials currentCred = VCommanderConfig.getCredentialWithoutDomainAndTypeFiltering(credentialsId);
        if (item == null ? (jenkinsInstance = Jenkins.getInstance()) != null && !jenkinsInstance.hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
            return result.with((IdCredentials)currentCred);
        }
        ArrayList<StandardCredentials> credentials = new ArrayList<StandardCredentials>();
        credentials.addAll(CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)address).build()));
        if (currentCred != null && !credentials.contains(currentCred)) {
            credentials.add(currentCred);
        }
        return result.withEmptySelection().withAll(credentials);
    }

    public FormValidation doCheckAddress(@QueryParameter String value) throws IOException, ServletException {
        if (value.length() == 0) {
            return FormValidation.error((String)Messages.VCommanderConfig_errors_missingAddress());
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckCredentialsId(@AncestorInPath Item item, @QueryParameter String address, @QueryParameter String credentialsId) {
        Jenkins jenkinsInstance;
        if (item == null ? (jenkinsInstance = Jenkins.getInstance()) != null && !jenkinsInstance.hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
            return FormValidation.ok();
        }
        if (StringUtils.isBlank((String)credentialsId)) {
            return FormValidation.ok();
        }
        if (VCommanderConfig.getCredential(credentialsId, address) == null) {
            return this.findCredentialProblem(credentialsId);
        }
        return FormValidation.ok();
    }

    public FormValidation doTestConnection(@QueryParameter(value="address") String address, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="orgName") String orgName) throws IOException, ServletException {
        if (StringUtils.isBlank((String)credentialsId)) {
            return FormValidation.error((String)Messages.VCommanderConfig_errors_missingCredential());
        }
        StandardUsernamePasswordCredentials cred = VCommanderConfig.getCredential(credentialsId, address);
        if (cred == null) {
            return this.findCredentialProblem(credentialsId);
        }
        try {
            VCommanderClient client = new VCommanderClient(address, cred.getUsername(), Secret.toString((Secret)cred.getPassword()), orgName);
            client.getSecurityToken();
            client.close();
            return FormValidation.ok((String)Messages.VCommanderConfig_connection_success());
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (e.getCause() != null && e.getCause() instanceof ConnectException) {
                message = Messages.VCommanderConfig_connection_failedConnection();
            }
            return FormValidation.error((String)Messages.VCommanderConfig_connection_failed(message));
        }
    }

    private FormValidation findCredentialProblem(String id) {
        if (VCommanderConfig.getCredential(id, null) != null) {
            return FormValidation.error((String)Messages.VCommanderConfig_errors_invalidCredentialDomain());
        }
        if (VCommanderConfig.getCredentialWithoutDomainAndTypeFiltering(id) != null) {
            return FormValidation.error((String)Messages.VCommanderConfig_errors_invalidCredentialType());
        }
        return FormValidation.error((String)Messages.VCommanderConfig_errors_deletedCredential());
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
}

