/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.echarts;

import java.util.List;
import java.util.Locale;

public enum JenkinsPalette {
    BLACK("", "", ""),
    BLUE,
    BROWN,
    CYAN,
    GREY("light-", "medium-", "dark-"),
    GREEN,
    INDIGO,
    ORANGE,
    PINK,
    PURPLE,
    RED,
    WHITE("", "", ""),
    YELLOW;

    static final List<JenkinsPalette> CHART_COLORS;
    private final String infixLight;
    private final String infixNormal;
    private final String infixDark;
    private static final String PREFIX = "--";
    private static final String DARK_INFIX = "dark-";
    private static final String LIGHT_INFIX = "light-";

    public static JenkinsPalette chartColor(int n) {
        return CHART_COLORS.get(n % CHART_COLORS.size());
    }

    private JenkinsPalette() {
        this(LIGHT_INFIX, "", DARK_INFIX);
    }

    private JenkinsPalette(String infixLight, String infixNormal, String infixDark) {
        this.infixLight = infixLight;
        this.infixNormal = infixNormal;
        this.infixDark = infixDark;
    }

    public String light() {
        return this.compose(this.infixLight);
    }

    public String normal() {
        return this.compose(this.infixNormal);
    }

    public String dark() {
        return this.compose(this.infixDark);
    }

    private String compose(String infix) {
        return PREFIX + infix + this.name().toLowerCase(Locale.ENGLISH);
    }

    static {
        CHART_COLORS = List.of(RED, BLUE, YELLOW, GREEN, CYAN, INDIGO, ORANGE, PINK, PURPLE, BROWN);
    }
}

