/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.echarts.line;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;

public class LinesDataSet {
    private final Map<String, List<Double>> dataSetSeries = new HashMap<String, List<Double>>();
    private final List<String> domainAxisLabels = new ArrayList<String>();
    private final List<Integer> buildNumbers = new ArrayList<Integer>();
    private int decimals = 2;

    public int getDomainAxisSize() {
        return this.domainAxisLabels.size();
    }

    public List<String> getDomainAxisLabels() {
        return this.domainAxisLabels;
    }

    public Set<String> getDataSetIds() {
        return this.dataSetSeries.keySet();
    }

    public void setDecimals(int decimals) {
        this.decimals = decimals;
    }

    public boolean containsSeries(String dataSetId) {
        return this.dataSetSeries.containsKey(dataSetId);
    }

    public boolean isEmpty() {
        return this.domainAxisLabels.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public List<Double> getSeries(String dataSetId) {
        if (!this.containsSeries(dataSetId)) {
            throw new NoSuchElementException(String.format("No dataset '%s' registered", dataSetId));
        }
        return this.getSeriesFromMap(dataSetId).stream().map(this::round).collect(Collectors.toList());
    }

    public double getMinimumValue() {
        return this.streamAllValues().min().orElseThrow(NoSuchElementException::new);
    }

    public double getMaximumValue() {
        return this.streamAllValues().max().orElseThrow(NoSuchElementException::new);
    }

    private DoubleStream streamAllValues() {
        return this.dataSetSeries.values().stream().flatMap(Collection::stream).map(this::round).mapToDouble(Double::doubleValue);
    }

    public void add(String domainAxisLabel, Map<String, Double> dataSetValues) {
        this.domainAxisLabels.add(domainAxisLabel);
        for (Map.Entry<String, Double> dataPoints : dataSetValues.entrySet()) {
            this.dataSetSeries.putIfAbsent(dataPoints.getKey(), new ArrayList());
            this.getSeriesFromMap(dataPoints.getKey()).add(Objects.requireNonNull(dataPoints.getValue()));
        }
    }

    public void add(String domainAxisLabel, Map<String, Double> dataSetValues, int buildNumber) {
        this.add(domainAxisLabel, dataSetValues);
        if (this.buildNumbers.contains(buildNumber)) {
            throw new IllegalStateException("Build number already registered: " + buildNumber);
        }
        this.buildNumbers.add(buildNumber);
    }

    private List<Double> getSeriesFromMap(String key) {
        return Objects.requireNonNull(this.dataSetSeries.get(key));
    }

    private double round(Double value) {
        return (double)Math.round(value * Math.pow(10.0, this.decimals)) / Math.pow(10.0, this.decimals);
    }

    public List<Integer> getBuildNumbers() {
        return this.buildNumbers;
    }
}

